/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;

public class VfsTask
extends Task {
    private static StandardFileSystemManager manager;

    protected FileObject resolveFile(String uri) throws FileSystemException {
        if (manager == null) {
            manager = new StandardFileSystemManager();
            manager.setLogger(new AntLogger());
            manager.init();
            this.getProject().addBuildListener((BuildListener)new CloseListener());
        }
        return manager.resolveFile(this.getProject().getBaseDir(), uri);
    }

    private class AntLogger
    implements Log {
        private AntLogger() {
        }

        public void debug(Object o) {
            VfsTask.this.log(String.valueOf(o), 4);
        }

        public void debug(Object o, Throwable throwable) {
            this.debug(o);
        }

        public void error(Object o) {
            VfsTask.this.log(String.valueOf(o), 0);
        }

        public void error(Object o, Throwable throwable) {
            this.error(o);
        }

        public void fatal(Object o) {
            VfsTask.this.log(String.valueOf(o), 0);
        }

        public void fatal(Object o, Throwable throwable) {
            this.fatal(o);
        }

        public void info(Object o) {
            VfsTask.this.log(String.valueOf(o), 2);
        }

        public void info(Object o, Throwable throwable) {
            this.info(o);
        }

        public void trace(Object o) {
        }

        public void trace(Object o, Throwable throwable) {
        }

        public void warn(Object o) {
            VfsTask.this.log(String.valueOf(o), 1);
        }

        public void warn(Object o, Throwable throwable) {
            this.warn(o);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isFatalEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return true;
        }
    }

    private class CloseListener
    implements BuildListener {
        private CloseListener() {
        }

        public void buildFinished(BuildEvent event) {
            if (manager != null) {
                manager.close();
                manager = null;
            }
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

