/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray.junit.customjunitxml;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class XmlReportData {
    private final Map<TestIdentifier, TestExecutionResult> finishedTests = new ConcurrentHashMap<TestIdentifier, TestExecutionResult>();
    private final Map<TestIdentifier, String> skippedTests = new ConcurrentHashMap<TestIdentifier, String>();
    private final Map<TestIdentifier, Instant> startInstants = new ConcurrentHashMap<TestIdentifier, Instant>();
    private final Map<TestIdentifier, Instant> endInstants = new ConcurrentHashMap<TestIdentifier, Instant>();
    private final Map<TestIdentifier, List<ReportEntry>> reportEntries = new ConcurrentHashMap<TestIdentifier, List<ReportEntry>>();
    private final TestPlan testPlan;
    private final Clock clock;

    XmlReportData(TestPlan testPlan, Clock clock) {
        this.testPlan = testPlan;
        this.clock = clock;
    }

    TestPlan getTestPlan() {
        return this.testPlan;
    }

    Clock getClock() {
        return this.clock;
    }

    void markSkipped(TestIdentifier testIdentifier, String reason) {
        this.skippedTests.put(testIdentifier, reason == null ? "" : reason);
    }

    void markStarted(TestIdentifier testIdentifier) {
        this.startInstants.put(testIdentifier, this.clock.instant());
    }

    void markFinished(TestIdentifier testIdentifier, TestExecutionResult result) {
        this.endInstants.put(testIdentifier, this.clock.instant());
        if (result.getStatus() == TestExecutionResult.Status.ABORTED) {
            String reason = result.getThrowable().map(ExceptionUtils::readStackTrace).orElse("");
            this.skippedTests.put(testIdentifier, reason);
        } else {
            this.finishedTests.put(testIdentifier, result);
        }
    }

    void addReportEntry(TestIdentifier testIdentifier, ReportEntry entry) {
        List entries = this.reportEntries.computeIfAbsent(testIdentifier, key -> new ArrayList());
        entries.add(entry);
    }

    boolean wasSkipped(TestIdentifier testIdentifier) {
        return this.findSkippedAncestor(testIdentifier).isPresent();
    }

    double getDurationInSeconds(TestIdentifier testIdentifier) {
        Instant startInstant = this.getStartInstant(testIdentifier);
        Instant endInstant = this.getEndInstant(testIdentifier);
        return TimeUnit.MILLISECONDS.toSeconds(Duration.between(startInstant, endInstant).toMillis());
    }

    Instant getStartInstant(TestIdentifier testIdentifier) {
        return this.startInstants.getOrDefault(testIdentifier, Instant.EPOCH);
    }

    Instant getEndInstant(TestIdentifier testIdentifier) {
        return this.endInstants.getOrDefault(testIdentifier, this.getStartInstant(testIdentifier));
    }

    String getSkipReason(TestIdentifier testIdentifier) {
        return this.findSkippedAncestor(testIdentifier).map(skippedTestIdentifier -> {
            String reason = this.skippedTests.get(skippedTestIdentifier);
            if (!testIdentifier.equals(skippedTestIdentifier)) {
                reason = "parent was skipped: '" + reason + "'";
            }
            return reason;
        }).orElse(null);
    }

    List<TestExecutionResult> getResults(TestIdentifier testIdentifier) {
        return this.getAncestors(testIdentifier).stream().map(this.finishedTests::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    List<ReportEntry> getReportEntries(TestIdentifier testIdentifier) {
        return this.reportEntries.getOrDefault(testIdentifier, Collections.emptyList());
    }

    private Optional<TestIdentifier> findSkippedAncestor(TestIdentifier testIdentifier) {
        return this.findAncestor(testIdentifier, this.skippedTests::containsKey);
    }

    private Optional<TestIdentifier> findAncestor(TestIdentifier testIdentifier, Predicate<TestIdentifier> predicate) {
        Optional current = Optional.of(testIdentifier);
        while (current.isPresent()) {
            if (predicate.test(current.get())) {
                return current;
            }
            current = this.testPlan.getParent(current.get());
        }
        return Optional.empty();
    }

    private List<TestIdentifier> getAncestors(TestIdentifier testIdentifier) {
        TestIdentifier current = testIdentifier;
        ArrayList<TestIdentifier> ancestors = new ArrayList<TestIdentifier>();
        while (current != null) {
            ancestors.add(current);
            current = this.testPlan.getParent(current).orElse(null);
        }
        return ancestors;
    }
}

