/*
 * Decompiled with CFR 0.152.
 */
package app.getxray.xray;

import app.getxray.xray.CommonCloud;
import app.getxray.xray.CommonUtils;
import app.getxray.xray.XrayResultsImporterException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONObject;

public class XrayResultsImporter {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private static final MediaType MEDIA_TYPE_XML = MediaType.parse((String)"application/xml");
    public static final String XRAY_FORMAT = "xray";
    public static final String JUNIT_FORMAT = "junit";
    public static final String TESTNG_FORMAT = "testng";
    public static final String ROBOT_FORMAT = "robot";
    public static final String XUNIT_FORMAT = "xunit";
    public static final String NUNIT_FORMAT = "nunit";
    public static final String CUCUMBER_FORMAT = "cucumber";
    public static final String BEHAVE_FORMAT = "behave";
    private static final String UNSUPPORTED_REPORT_FORMAT = "unsupported report format: ";
    private static final String UNEXPECTED_HTTP_CODE = "Unexpected HTTP code ";
    private static final String BEARER_HEADER_PREFIX = "Bearer ";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private String jiraBaseUrl;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraPersonalAccessToken;
    private String clientId;
    private String clientSecret;
    private String projectKey;
    private String fixVersion;
    private String revision;
    private String testPlanKey;
    private String testExecKey;
    private String testEnvironment;
    private Boolean ignoreSslErrors = false;
    private Boolean useInternalTestProxy = false;
    private Integer timeout = 50;
    private Boolean verbose = false;
    private Log logger;

    private XrayResultsImporter(ServerDCBuilder builder) {
        this.jiraBaseUrl = builder.jiraBaseUrl;
        this.jiraUsername = builder.jiraUsername;
        this.jiraPassword = builder.jiraPassword;
        this.jiraPersonalAccessToken = builder.jiraPersonalAccessToken;
        this.projectKey = builder.projectKey;
        this.fixVersion = builder.fixVersion;
        this.revision = builder.revision;
        this.testPlanKey = builder.testPlanKey;
        this.testExecKey = builder.testExecKey;
        this.testEnvironment = builder.testEnvironment;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    private XrayResultsImporter(CloudBuilder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.projectKey = builder.projectKey;
        this.fixVersion = builder.fixVersion;
        this.revision = builder.revision;
        this.testPlanKey = builder.testPlanKey;
        this.testExecKey = builder.testExecKey;
        this.testEnvironment = builder.testEnvironment;
        this.ignoreSslErrors = builder.ignoreSslErrors;
        this.useInternalTestProxy = builder.useInternalTestProxy;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
        this.logger = builder.logger;
    }

    public String submit(String format, String reportFile) throws IOException, XrayResultsImporterException {
        if (this.clientId != null) {
            return this.submitStandardCloud(format, reportFile);
        }
        return this.submitStandardServerDC(format, reportFile);
    }

    public String submitMultipartServerDC(String format, String reportFile, JSONObject testExecInfo, JSONObject testInfo) throws XrayResultsImporterException, IOException {
        OkHttpClient client = CommonUtils.createHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String credentials = this.generateDCAuthorizationHeaderContent();
        MediaType mediaType = this.getMediaTypeForFormat(format);
        String endpointUrl = XRAY_FORMAT.equals(format) ? this.jiraBaseUrl + "/rest/raven/2.0/import/execution/multipart" : this.jiraBaseUrl + "/rest/raven/2.0/import/execution/" + format + "/multipart";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        String partName = XRAY_FORMAT.equals(format) || CUCUMBER_FORMAT.equals(format) || BEHAVE_FORMAT.equals(format) ? "result" : "file";
        try {
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, reportFile, RequestBody.create((File)new File(reportFile), (MediaType)mediaType)).addFormDataPart("info", "info.json", RequestBody.create((String)testExecInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
            if (testInfo != null) {
                requestBodyBuilder.addFormDataPart("testInfo", "testInfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
            }
            requestBody = requestBodyBuilder.build();
        }
        catch (Exception e1) {
            this.logger.error((Throwable)e1);
            throw e1;
        }
        return this.makeHttpRequest(client, credentials, builder, (RequestBody)requestBody);
    }

    private String makeHttpRequest(OkHttpClient client, String credentials, HttpUrl.Builder builder, RequestBody requestBody) throws XrayResultsImporterException {
        Request request = new Request.Builder().url(builder.build()).post(requestBody).addHeader(AUTHORIZATION_HEADER, credentials).build();
        CommonUtils.logRequest(this.logger, request, this.verbose);
        try {
            Response response = client.newCall(request).execute();
            CommonUtils.logResponse(this.logger, response, this.verbose);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                return responseBody;
            }
            throw new IOException(UNEXPECTED_HTTP_CODE + response);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            throw new XrayResultsImporterException(e.getMessage());
        }
    }

    public String submitMultipartCloud(String format, String reportFile, JSONObject testExecInfo, JSONObject testInfo) throws IOException, XrayResultsImporterException {
        OkHttpClient client = CommonUtils.createHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String authToken = CommonCloud.authenticateXrayAPIKeyCredentials(this.logger, this.verbose, client, this.clientId, this.clientSecret);
        String credentials = BEARER_HEADER_PREFIX + authToken;
        MediaType mediaType = this.getMediaTypeForFormat(format);
        String endpointUrl = XRAY_FORMAT.equals(format) ? "https://xray.cloud.getxray.app/api/v2/import/execution/multipart" : "https://xray.cloud.getxray.app/api/v2/import/execution/" + format + "/multipart";
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        MultipartBody requestBody = null;
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("results", reportFile, RequestBody.create((File)new File(reportFile), (MediaType)mediaType)).addFormDataPart("info", "info.json", RequestBody.create((String)testExecInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
        if (testInfo != null) {
            requestBodyBuilder.addFormDataPart("testInfo", "testInfo.json", RequestBody.create((String)testInfo.toString(), (MediaType)MEDIA_TYPE_JSON));
        }
        requestBody = requestBodyBuilder.build();
        return this.makeHttpRequest(client, credentials, builder, (RequestBody)requestBody);
    }

    public String generateDCAuthorizationHeaderContent() {
        if (this.jiraPersonalAccessToken != null) {
            return BEARER_HEADER_PREFIX + this.jiraPersonalAccessToken;
        }
        return Credentials.basic((String)this.jiraUsername, (String)this.jiraPassword);
    }

    public String submitStandardServerDC(String format, String reportFile) throws IOException, XrayResultsImporterException {
        OkHttpClient client = CommonUtils.createHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String credentials = this.generateDCAuthorizationHeaderContent();
        MediaType mediaType = this.getMediaTypeForFormat(format);
        String endpointUrl = XRAY_FORMAT.equals(format) ? this.jiraBaseUrl + "/rest/raven/2.0/import/execution" : this.jiraBaseUrl + "/rest/raven/2.0/import/execution/" + format;
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        RequestBody requestBody = null;
        if (XRAY_FORMAT.equals(format) || CUCUMBER_FORMAT.equals(format) || BEHAVE_FORMAT.equals(format)) {
            String reportContent = new String(Files.readAllBytes(Paths.get(reportFile, new String[0])));
            requestBody = RequestBody.create((String)reportContent, (MediaType)mediaType);
        } else {
            requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", reportFile, RequestBody.create((File)new File(reportFile), (MediaType)mediaType)).build();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("projectKey", this.projectKey);
            parameters.put("fixVersion", this.fixVersion);
            parameters.put("revision", this.revision);
            parameters.put("testPlanKey", this.testPlanKey);
            parameters.put("testExecKey", this.testExecKey);
            parameters.put("testEnvironments", this.testEnvironment);
            for (Map.Entry entry : parameters.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                builder.addQueryParameter((String)entry.getKey(), value);
            }
        }
        return this.makeHttpRequest(client, credentials, builder, requestBody);
    }

    private MediaType getMediaTypeForFormat(String format) {
        String[] supportedFormats = new String[]{XRAY_FORMAT, JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT, CUCUMBER_FORMAT, BEHAVE_FORMAT};
        if (!Arrays.asList(supportedFormats).contains(format)) {
            throw new IllegalArgumentException(UNSUPPORTED_REPORT_FORMAT + format);
        }
        String[] xmlBasedFormats = new String[]{JUNIT_FORMAT, TESTNG_FORMAT, ROBOT_FORMAT, NUNIT_FORMAT, XUNIT_FORMAT};
        MediaType mediaType = Arrays.asList(xmlBasedFormats).contains(format) ? MEDIA_TYPE_XML : MEDIA_TYPE_JSON;
        return mediaType;
    }

    public String submitStandardCloud(String format, String reportFile) throws IOException, XrayResultsImporterException {
        OkHttpClient client = CommonUtils.createHttpClient(this.useInternalTestProxy, this.ignoreSslErrors, this.timeout);
        String authToken = CommonCloud.authenticateXrayAPIKeyCredentials(this.logger, this.verbose, client, this.clientId, this.clientSecret);
        String credentials = BEARER_HEADER_PREFIX + authToken;
        MediaType mediaType = this.getMediaTypeForFormat(format);
        String endpointUrl = XRAY_FORMAT.equals(format) ? "https://xray.cloud.getxray.app/api/v2/import/execution" : "https://xray.cloud.getxray.app/api/v2/import/execution/" + format;
        String reportContent = new String(Files.readAllBytes(Paths.get(reportFile, new String[0])));
        RequestBody requestBody = RequestBody.create((String)reportContent, (MediaType)mediaType);
        HttpUrl url = HttpUrl.get((String)endpointUrl);
        HttpUrl.Builder builder = url.newBuilder();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("projectKey", this.projectKey);
        parameters.put("fixVersion", this.fixVersion);
        parameters.put("revision", this.revision);
        parameters.put("testPlanKey", this.testPlanKey);
        parameters.put("testExecKey", this.testExecKey);
        parameters.put("testEnvironments", this.testEnvironment);
        for (Map.Entry entry : parameters.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            builder.addQueryParameter((String)entry.getKey(), value);
        }
        return this.makeHttpRequest(client, credentials, builder, requestBody);
    }

    public static class CloudBuilder {
        private final String clientId;
        private final String clientSecret;
        private String projectKey;
        private String fixVersion;
        private String revision;
        private String testPlanKey;
        private String testExecKey;
        private String testEnvironment;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public CloudBuilder(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public CloudBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public CloudBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public CloudBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CloudBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public CloudBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public CloudBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public CloudBuilder withVersion(String fixVersion) {
            this.fixVersion = fixVersion;
            return this;
        }

        public CloudBuilder withRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public CloudBuilder withTestPlanKey(String testPlanKey) {
            this.testPlanKey = testPlanKey;
            return this;
        }

        public CloudBuilder withTestExecKey(String testExecKey) {
            this.testExecKey = testExecKey;
            return this;
        }

        public CloudBuilder withTestEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public XrayResultsImporter build() {
            return new XrayResultsImporter(this);
        }
    }

    public static class ServerDCBuilder {
        private final String jiraBaseUrl;
        private String jiraUsername;
        private String jiraPassword;
        private String jiraPersonalAccessToken;
        private String projectKey;
        private String fixVersion;
        private String revision;
        private String testPlanKey;
        private String testExecKey;
        private String testEnvironment;
        private Boolean ignoreSslErrors = false;
        private Boolean useInternalTestProxy = false;
        private Integer timeout = 50;
        private Boolean verbose = false;
        private Log logger;

        public ServerDCBuilder(String jiraBaseUrl, String jiraUsername, String jiraPassword) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraUsername = jiraUsername;
            this.jiraPassword = jiraPassword;
        }

        public ServerDCBuilder(String jiraBaseUrl, String jiraPersonalAccessToken) {
            this.jiraBaseUrl = jiraBaseUrl;
            this.jiraPersonalAccessToken = jiraPersonalAccessToken;
        }

        public ServerDCBuilder withIgnoreSslErrors(Boolean ignoreSslErrors) {
            this.ignoreSslErrors = ignoreSslErrors;
            return this;
        }

        public ServerDCBuilder withInternalTestProxy(Boolean useInternalTestProxy) {
            this.useInternalTestProxy = useInternalTestProxy;
            return this;
        }

        public ServerDCBuilder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ServerDCBuilder withVerbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public ServerDCBuilder withLogger(Log logger) {
            this.logger = logger;
            return this;
        }

        public ServerDCBuilder withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ServerDCBuilder withVersion(String fixVersion) {
            this.fixVersion = fixVersion;
            return this;
        }

        public ServerDCBuilder withRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public ServerDCBuilder withTestPlanKey(String testPlanKey) {
            this.testPlanKey = testPlanKey;
            return this;
        }

        public ServerDCBuilder withTestExecKey(String testExecKey) {
            this.testExecKey = testExecKey;
            return this;
        }

        public ServerDCBuilder withTestEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public XrayResultsImporter build() {
            return new XrayResultsImporter(this);
        }
    }
}

