/*
 * Decompiled with CFR 0.152.
 */
package bakersoftware.maven_replacer_plugin;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class ReplacerMojo
extends AbstractMojo {
    private String file;
    private String token;
    private String value;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Replacing " + this.token + " with " + this.value + " in " + this.file));
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            if (line == null) {
                throw new IOException("Could not read");
            }
            while (line != null) {
                buffer.append(line.replaceAll(this.token, this.value) + System.getProperty("line.separator"));
                line = reader.readLine();
            }
            reader.close();
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(this.file));
            writer.write(buffer.toString());
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

