/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;

public class AbstractZoomInteractor
extends InteractorAdapter {
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;
    protected Line2D markerTop;
    protected Line2D markerLeft;
    protected Line2D markerBottom;
    protected Line2D markerRight;
    protected Overlay overlay = new ZoomOverlay();
    protected BasicStroke markerStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);

    public boolean endInteraction() {
        return this.finished;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.finished) {
            this.mouseExited(mouseEvent);
            return;
        }
        this.finished = false;
        this.markerTop = null;
        this.markerLeft = null;
        this.markerBottom = null;
        this.markerRight = null;
        this.xStart = mouseEvent.getX();
        this.yStart = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.overlay.paint(jGVTComponent.getGraphics());
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        if (this.xCurrent - this.xStart != 0 && this.yCurrent - this.yStart != 0) {
            int n = this.xCurrent - this.xStart;
            int n2 = this.yCurrent - this.yStart;
            if (n < 0) {
                n = -n;
                this.xStart = this.xCurrent;
            }
            if (n2 < 0) {
                n2 = -n2;
                this.yStart = this.yCurrent;
            }
            Dimension dimension = jGVTComponent.getSize();
            float f = (float)dimension.width / (float)n;
            float f2 = (float)dimension.height / (float)n2;
            float f3 = f < f2 ? f : f2;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(f3, f3);
            affineTransform.translate(-this.xStart, -this.yStart);
            affineTransform.concatenate(jGVTComponent.getRenderingTransform());
            jGVTComponent.setRenderingTransform(affineTransform);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.overlay.paint(jGVTComponent.getGraphics());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        float f;
        float f2;
        float f3;
        float f4;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.overlay.paint(jGVTComponent.getGraphics());
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        if (this.xStart < this.xCurrent) {
            f4 = this.xStart;
            f3 = this.xCurrent - this.xStart;
        } else {
            f4 = this.xCurrent;
            f3 = this.xStart - this.xCurrent;
        }
        if (this.yStart < this.yCurrent) {
            f2 = this.yStart;
            f = this.yCurrent - this.yStart;
        } else {
            f2 = this.yCurrent;
            f = this.yStart - this.yCurrent;
        }
        Dimension dimension = jGVTComponent.getSize();
        float f5 = (float)dimension.width / (float)dimension.height;
        if (f5 > f3 / f) {
            f3 = f5 * f;
        } else {
            f = f3 / f5;
        }
        this.markerTop = new Line2D.Float(f4, f2, f4 + f3, f2);
        this.markerLeft = new Line2D.Float(f4, f2, f4, f2 + f);
        this.markerBottom = new Line2D.Float(f4, f2 + f, f4 + f3, f2 + f);
        this.markerRight = new Line2D.Float(f4 + f3, f2, f4 + f3, f2 + f);
        this.overlay.paint(jGVTComponent.getGraphics());
    }

    protected class ZoomOverlay
    implements Overlay {
        protected ZoomOverlay() {
        }

        public void paint(Graphics graphics) {
            if (AbstractZoomInteractor.this.markerTop != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setXORMode(Color.white);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(AbstractZoomInteractor.this.markerStroke);
                graphics2D.draw(AbstractZoomInteractor.this.markerTop);
                graphics2D.draw(AbstractZoomInteractor.this.markerLeft);
                graphics2D.draw(AbstractZoomInteractor.this.markerBottom);
                graphics2D.draw(AbstractZoomInteractor.this.markerRight);
            }
        }
    }
}

