/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.VisitedObjects;

class RecordInput
extends TupleInput
implements EntityInput {
    private Catalog catalog;
    private boolean rawAccess;
    private VisitedObjects visited;
    private DatabaseEntry priKeyEntry;
    private int priKeyFormatId;

    RecordInput(Catalog catalog, boolean rawAccess, DatabaseEntry priKeyEntry, int priKeyFormatId, byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        this.catalog = catalog;
        this.rawAccess = rawAccess;
        this.priKeyEntry = priKeyEntry;
        this.priKeyFormatId = priKeyFormatId;
    }

    private RecordInput(RecordInput other, int offset) {
        this(other.catalog, other.rawAccess, other.priKeyEntry, other.priKeyFormatId, other.buf, offset, other.len);
        this.visited = other.visited;
    }

    private RecordInput(RecordInput other, DatabaseEntry entry) {
        this(other.catalog, other.rawAccess, other.priKeyEntry, other.priKeyFormatId, entry.getData(), entry.getOffset(), entry.getSize());
        this.visited = other.visited;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public boolean isRawAccess() {
        return this.rawAccess;
    }

    public boolean setRawAccess(boolean rawAccessParam) {
        boolean original = this.rawAccess;
        this.rawAccess = rawAccessParam;
        return original;
    }

    public Object readObject() {
        int visitedOffset = this.off;
        RecordInput useInput = this;
        int formatId = this.readPackedInt();
        Object o = null;
        if (formatId == 0) {
            return null;
        }
        if (formatId < 0) {
            int offset = -(formatId + 1);
            if (this.visited != null) {
                o = this.visited.getObject(offset);
            }
            if (o == VisitedObjects.PROHIBIT_REF_OBJECT) {
                throw new IllegalArgumentException("Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied");
            }
            if (o != null) {
                return o;
            }
            visitedOffset = offset;
            if (offset == 0x7FFFFFFE) {
                assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                useInput = new RecordInput(this, this.priKeyEntry);
                formatId = this.priKeyFormatId;
            } else {
                useInput = new RecordInput(this, offset);
                formatId = useInput.readPackedInt();
            }
        }
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        int visitedIndex = this.visited.add(VisitedObjects.PROHIBIT_REF_OBJECT, visitedOffset);
        Format format = this.catalog.getFormat(formatId);
        Reader reader = format.getReader();
        o = reader.newInstance(useInput, this.rawAccess);
        this.visited.setObject(visitedIndex, o);
        Object o2 = reader.readObject(o, useInput, this.rawAccess);
        if (o != o2) {
            this.visited.replaceObject(o, o2);
        }
        return o2;
    }

    public Object readKeyObject(Format format) {
        Reader reader = format.getReader();
        Object o = reader.newInstance(this, this.rawAccess);
        return reader.readObject(o, this, this.rawAccess);
    }

    KeyLocation getKeyLocation(Format fieldFormat) {
        RecordInput input = this;
        if (!fieldFormat.isPrimitive()) {
            int formatId = input.readPackedInt();
            if (formatId == 0) {
                return null;
            }
            if (formatId < 0) {
                int offset = -(formatId + 1);
                if (offset == 0x7FFFFFFE) {
                    assert (this.priKeyEntry != null && this.priKeyFormatId > 0);
                    input = new RecordInput(this, this.priKeyEntry);
                    formatId = this.priKeyFormatId;
                } else {
                    input = new RecordInput(this, offset);
                    formatId = input.readPackedInt();
                }
            }
            fieldFormat = this.catalog.getFormat(formatId);
        }
        return new KeyLocation(input, fieldFormat);
    }

    public void registerPriKeyObject(Object o) {
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(o, 0x7FFFFFFE);
    }

    public void skipField(Format declaredFormat) {
        if (declaredFormat != null && declaredFormat.isPrimitive()) {
            declaredFormat.skipContents(this);
        } else {
            int formatId = this.readPackedInt();
            if (formatId > 0) {
                Format format = this.catalog.getFormat(formatId);
                format.skipContents(this);
            }
        }
    }

    public int readArrayLength() {
        return this.readPackedInt();
    }

    public int readEnumConstant(String[] names) {
        return this.readPackedInt();
    }
}

