/*
 * Decompiled with CFR 0.152.
 */
package aQute.junit.runtime;

import aQute.junit.runtime.GenericFramework;
import java.lang.reflect.Method;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class BasicTestReport
implements TestListener {
    int errors;
    boolean verbose = true;
    private Bundle targetBundle;

    BasicTestReport() {
    }

    public void begin(GenericFramework fw, Bundle targetBundle, List tests, int realcount) {
        this.targetBundle = targetBundle;
        if (this.verbose) {
            System.out.println("====================================================================");
        }
    }

    public void addError(Test test, Throwable t) {
        ++this.errors;
        if (this.verbose) {
            System.out.println(test + " : ");
            t.printStackTrace(System.out);
            System.out.println();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        ++this.errors;
        if (this.verbose) {
            System.out.println();
            System.out.print(test + " : ");
            t.getMessage();
        }
    }

    public void endTest(Test test) {
        if (this.verbose) {
            System.out.print("<< " + test + "\n");
        }
    }

    public void startTest(Test test) {
        try {
            Method m = test.getClass().getMethod("setBundleContext", BundleContext.class);
            m.invoke((Object)test, this.targetBundle.getBundleContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.verbose) {
            System.out.println(">> " + test + "\n");
        }
    }

    public void end() {
        if (this.verbose) {
            System.out.println("-------------------------------------------------------------------------");
            if (this.errors == 0) {
                System.out.println("No errors :-)");
            } else if (this.errors == 1) {
                System.out.println("One error :-|");
            } else {
                System.out.println(this.errors + " errors :-(");
            }
            System.out.println();
            System.out.println();
        }
    }
}

