/*
 * Decompiled with CFR 0.152.
 */
package aQute.junit.runtime;

import aQute.junit.runtime.GenericFramework;
import aQute.junit.runtime.TestReporter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JUnitReport
implements TestReporter {
    int port;
    boolean open;
    BufferedReader in;
    PrintWriter out;
    long startTime;
    GenericFramework framework;
    Bundle targetBundle;
    List tests;
    boolean verbose = false;

    public JUnitReport(int port) throws Exception {
        Socket socket = null;
        for (int i = 0; socket == null && i < 10; ++i) {
            try {
                socket = new Socket("127.0.0.1", port);
                continue;
            }
            catch (ConnectException ce) {
                Thread.sleep(i * 100);
            }
        }
        if (socket == null) {
            System.exit(-1);
        }
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        this.out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
    }

    public void begin(GenericFramework fw, Bundle targetBundle, List tests, int realcount) {
        this.framework = fw;
        this.targetBundle = targetBundle;
        this.tests = tests;
        this.message("%TESTC  ", realcount + " v2");
        if (tests != null) {
            this.report(tests);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.message("%RUNTIME", "" + (System.currentTimeMillis() - this.startTime));
        this.out.flush();
        this.out.close();
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addError(Test test, Throwable t) {
        this.message("%ERROR  ", test);
        this.trace(t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.message("%FAILED ", test);
        this.trace((Throwable)t);
    }

    void trace(Throwable t) {
        this.message("%TRACES ", "");
        t.printStackTrace(this.out);
        this.out.println();
        this.message("%TRACEE ", "");
    }

    public void endTest(Test test) {
        this.message("%TESTE  ", test);
    }

    public void startTest(Test test) {
        this.message("%TESTS  ", test);
        try {
            Method m = test.getClass().getMethod("setBundleContext", BundleContext.class);
            m.invoke((Object)test, this.targetBundle.getBundleContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void message(String key, String payload) {
        if (key.length() != 8) {
            throw new IllegalArgumentException(key + " is not 8 characters");
        }
        this.out.print(key);
        this.out.println(payload);
        this.out.flush();
        if (this.verbose) {
            System.out.println(key + payload);
        }
    }

    private void message(String key, Test test) {
        this.message(key, test.toString());
    }

    private void report(List flattened) {
        for (int i = 0; i < flattened.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(i + 1);
            sb.append(",");
            Test test = (Test)flattened.get(i);
            sb.append(flattened.get(i));
            sb.append(",");
            sb.append(test instanceof TestSuite);
            sb.append(",");
            sb.append(test.countTestCases());
            this.message("%TSTTREE", sb.toString());
        }
    }
}

