/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Touchable;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.ant.util.StringUtils;

public class FileUtils {
    private static final int EXPAND_SPACE = 50;
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
    private static final boolean ON_NETWARE = Os.isFamily("netware");
    private static final boolean ON_DOS = Os.isFamily("dos");
    private static final boolean ON_WIN9X = Os.isFamily("win9x");
    private static final boolean ON_WINDOWS = Os.isFamily("windows");
    static final int BUF_SIZE = 8192;
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;
    public static final long NTFS_FILE_TIMESTAMP_GRANULARITY = 1L;
    private Object cacheFromUriLock = new Object();
    private String cacheFromUriRequest = null;
    private String cacheFromUriResponse = null;
    static /* synthetic */ Class class$java$io$File;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public URL getFileURL(File file) throws MalformedURLException {
        return new URL(this.toURI(file.getAbsolutePath()));
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), null, false, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, false, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, preserveLastModified);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified, String encoding) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, preserveLastModified, encoding);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String encoding, Project project) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, filterChains, overwrite, preserveLastModified, encoding, project);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, filterChains, overwrite, preserveLastModified, inputEncoding, outputEncoding, project);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, null, false, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters) throws IOException {
        this.copyFile(sourceFile, destFile, filters, false, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite) throws IOException {
        this.copyFile(sourceFile, destFile, filters, overwrite, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(sourceFile, destFile, filters, overwrite, preserveLastModified, null);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified, String encoding) throws IOException {
        this.copyFile(sourceFile, destFile, filters, null, overwrite, preserveLastModified, encoding, null);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String encoding, Project project) throws IOException {
        this.copyFile(sourceFile, destFile, filters, filterChains, overwrite, preserveLastModified, encoding, encoding, project);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        ResourceUtils.copyResource((Resource)new FileResource(sourceFile), (Resource)new FileResource(destFile), (FilterSetCollection)filters, (Vector)filterChains, (boolean)overwrite, (boolean)preserveLastModified, (String)inputEncoding, (String)outputEncoding, (Project)project);
    }

    public void setFileLastModified(File file, long time) {
        ResourceUtils.setLastModified((Touchable)new FileResource(file), (long)time);
    }

    public File resolveFile(File file, String filename) {
        if (!FileUtils.isAbsolutePath(filename)) {
            char sep = File.separatorChar;
            if (FileUtils.isContextRelativePath(filename = filename.replace('/', sep).replace('\\', sep))) {
                file = null;
                String udir = System.getProperty("user.dir");
                if (filename.charAt(0) == sep && udir.charAt(0) == sep) {
                    filename = this.dissect(udir)[0] + filename.substring(1);
                }
            }
            filename = new File(file, filename).getAbsolutePath();
        }
        return this.normalize(filename);
    }

    public static boolean isContextRelativePath(String filename) {
        if (!ON_DOS && !ON_NETWARE || filename.length() == 0) {
            return false;
        }
        char sep = File.separatorChar;
        filename = filename.replace('/', sep).replace('\\', sep);
        char c = filename.charAt(0);
        int len = filename.length();
        return c == sep && (len == 1 || filename.charAt(1) != sep) || Character.isLetter(c) && len > 1 && filename.indexOf(58) == 1 && (len == 2 || filename.charAt(2) != sep);
    }

    public static boolean isAbsolutePath(String filename) {
        int len = filename.length();
        if (len == 0) {
            return false;
        }
        char sep = File.separatorChar;
        filename = filename.replace('/', sep).replace('\\', sep);
        char c = filename.charAt(0);
        if (!ON_DOS && !ON_NETWARE) {
            return c == sep;
        }
        if (c == sep) {
            if (!ON_DOS || len <= 4 || filename.charAt(1) != sep) {
                return false;
            }
            int nextsep = filename.indexOf(sep, 2);
            return nextsep > 2 && nextsep + 1 < len;
        }
        int colon = filename.indexOf(58);
        return Character.isLetter(c) && colon == 1 && filename.length() > 2 && filename.charAt(2) == sep || ON_NETWARE && colon > 0;
    }

    public static String translatePath(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return "";
        }
        StringBuffer path = new StringBuffer(toProcess.length() + 50);
        PathTokenizer tokenizer = new PathTokenizer(toProcess);
        while (tokenizer.hasMoreTokens()) {
            String pathComponent = tokenizer.nextToken();
            pathComponent = pathComponent.replace('/', File.separatorChar);
            pathComponent = pathComponent.replace('\\', File.separatorChar);
            if (path.length() != 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(pathComponent);
        }
        return path.toString();
    }

    public File normalize(String path) {
        Stack<String> s = new Stack<String>();
        String[] dissect = this.dissect(path);
        s.push(dissect[0]);
        StringTokenizer tok = new StringTokenizer(dissect[1], File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    return new File(path);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
        }
        return new File(sb.toString());
    }

    public String[] dissect(String path) {
        char sep = File.separatorChar;
        if (!FileUtils.isAbsolutePath(path = path.replace('/', sep).replace('\\', sep))) {
            throw new BuildException(path + " is not an absolute path");
        }
        String root = null;
        int colon = path.indexOf(58);
        if (colon > 0 && (ON_DOS || ON_NETWARE)) {
            int next = colon + 1;
            root = path.substring(0, next);
            char[] ca = path.toCharArray();
            root = root + sep;
            next = ca[next] == sep ? next + 1 : next;
            StringBuffer sbPath = new StringBuffer();
            for (int i = next; i < ca.length; ++i) {
                if (ca[i] == sep && ca[i - 1] == sep) continue;
                sbPath.append(ca[i]);
            }
            path = sbPath.toString();
        } else if (path.length() > 1 && path.charAt(1) == sep) {
            int nextsep = path.indexOf(sep, 2);
            root = (nextsep = path.indexOf(sep, nextsep + 1)) > 2 ? path.substring(0, nextsep + 1) : path;
            path = path.substring(root.length());
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        return new String[]{root, path};
    }

    public String toVMSPath(File f) {
        String path = this.normalize(f.getAbsolutePath()).getPath();
        String name = f.getName();
        boolean isAbsolute = path.charAt(0) == File.separatorChar;
        boolean isDirectory = f.isDirectory() && !name.regionMatches(true, name.length() - 4, ".DIR", 0, 4);
        String device = null;
        StringBuffer directory = null;
        String file = null;
        int index = 0;
        if (isAbsolute) {
            index = path.indexOf(File.separatorChar, 1);
            if (index == -1) {
                return path.substring(1) + ":[000000]";
            }
            device = path.substring(1, index++);
        }
        if (isDirectory) {
            directory = new StringBuffer(path.substring(index).replace(File.separatorChar, '.'));
        } else {
            int dirEnd = path.lastIndexOf(File.separatorChar, path.length());
            if (dirEnd == -1 || dirEnd < index) {
                file = path.substring(index);
            } else {
                directory = new StringBuffer(path.substring(index, dirEnd).replace(File.separatorChar, '.'));
                index = dirEnd + 1;
                if (path.length() > index) {
                    file = path.substring(index);
                }
            }
        }
        if (!isAbsolute && directory != null) {
            directory.insert(0, '.');
        }
        String osPath = (device != null ? device + ":" : "") + (directory != null ? "[" + directory + "]" : "") + (file != null ? file : "");
        return osPath;
    }

    public File createTempFile(String prefix, String suffix, File parentDir) {
        return this.createTempFile(prefix, suffix, parentDir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit, boolean createFile) {
        String parent;
        File result = null;
        String string = parent = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getPath();
        if (createFile) {
            try {
                result = File.createTempFile(prefix, suffix, new File(parent));
            }
            catch (IOException e) {
                throw new BuildException("Could not create tempfile in " + parent, e);
            }
        }
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((result = new File(parent, prefix + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
            }
        }
        if (deleteOnExit) {
            result.deleteOnExit();
        }
        return result;
    }

    public File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit) {
        return this.createTempFile(prefix, suffix, parentDir, deleteOnExit, false);
    }

    public boolean contentEquals(File f1, File f2) throws IOException {
        return this.contentEquals(f1, f2, false);
    }

    public boolean contentEquals(File f1, File f2, boolean textfile) throws IOException {
        return ResourceUtils.contentEquals((Resource)new FileResource(f1), (Resource)new FileResource(f2), (boolean)textfile);
    }

    public File getParentFile(File f) {
        return f == null ? null : f.getParentFile();
    }

    public static String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, 8192);
    }

    public static String readFully(Reader rdr, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        int bufferLength = 0;
        StringBuffer textBuffer = null;
        while (bufferLength != -1) {
            bufferLength = rdr.read(buffer);
            if (bufferLength <= 0) continue;
            textBuffer = textBuffer == null ? new StringBuffer() : textBuffer;
            textBuffer.append(new String(buffer, 0, bufferLength));
        }
        return textBuffer == null ? null : textBuffer.toString();
    }

    public static String safeReadFully(Reader reader) throws IOException {
        String ret = FileUtils.readFully(reader);
        return ret == null ? "" : ret;
    }

    public boolean createNewFile(File f) throws IOException {
        return f.createNewFile();
    }

    public boolean createNewFile(File f, boolean mkdirs) throws IOException {
        File parent = f.getParentFile();
        if (mkdirs && !parent.exists()) {
            parent.mkdirs();
        }
        return f.createNewFile();
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File toTest;
        if (parent == null) {
            File f = new File(name);
            parent = f.getParentFile();
            name = f.getName();
        }
        return !(toTest = new File(parent.getCanonicalPath(), name)).getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    public String removeLeadingPath(File leading, File path) {
        String p;
        String l = this.normalize(leading.getAbsolutePath()).getAbsolutePath();
        if (l.equals(p = this.normalize(path.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        return p.startsWith(l) ? p.substring(l.length()) : p;
    }

    public boolean isLeadingPath(File leading, File path) {
        String p;
        String l = this.normalize(leading.getAbsolutePath()).getAbsolutePath();
        if (l.equals(p = this.normalize(path.getAbsolutePath()).getAbsolutePath())) {
            return true;
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        return p.startsWith(l);
    }

    public String toURI(String path) {
        Class<?> uriClazz = null;
        try {
            uriClazz = Class.forName("java.net.URI");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (uriClazz != null) {
            try {
                File f = new File(path).getAbsoluteFile();
                Method toURIMethod = (class$java$io$File == null ? (class$java$io$File = FileUtils.class$("java.io.File")) : class$java$io$File).getMethod("toURI", new Class[0]);
                Object uriObj = toURIMethod.invoke((Object)f, new Object[0]);
                Method toASCIIStringMethod = uriClazz.getMethod("toASCIIString", new Class[0]);
                return (String)toASCIIStringMethod.invoke(uriObj, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean isDir = new File(path).isDirectory();
        StringBuffer sb = new StringBuffer("file:");
        path = this.resolveFile(null, path).getPath();
        sb.append("//");
        if (!path.startsWith(File.separator)) {
            sb.append("/");
        }
        path = path.replace('\\', '/');
        try {
            sb.append(Locator.encodeURI((String)path));
        }
        catch (UnsupportedEncodingException exc) {
            throw new BuildException(exc);
        }
        if (isDir && !path.endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fromURI(String uri) {
        Object object = this.cacheFromUriLock;
        synchronized (object) {
            if (uri.equals(this.cacheFromUriRequest)) {
                return this.cacheFromUriResponse;
            }
            String path = Locator.fromURI((String)uri);
            String ret = FileUtils.isAbsolutePath(path) ? this.normalize(path).getAbsolutePath() : path;
            this.cacheFromUriRequest = uri;
            this.cacheFromUriResponse = ret;
            return ret;
        }
    }

    public boolean fileNameEquals(File f1, File f2) {
        return this.normalize(f1.getAbsolutePath()).getAbsolutePath().equals(this.normalize(f2.getAbsolutePath()).getAbsolutePath());
    }

    public void rename(File from, File to) throws IOException {
        from = this.normalize(from.getAbsolutePath()).getCanonicalFile();
        to = this.normalize(to.getAbsolutePath());
        if (!from.exists()) {
            System.err.println("Cannot rename nonexistent file " + from);
            return;
        }
        if (from.equals(to)) {
            System.err.println("Rename of " + from + " to " + to + " is a no-op.");
            return;
        }
        if (to.exists() && !from.equals(to.getCanonicalFile()) && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            this.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    public long getFileTimestampGranularity() {
        if (ON_WIN9X) {
            return 2000L;
        }
        if (ON_WINDOWS) {
            return 1L;
        }
        if (ON_DOS) {
            return 2000L;
        }
        return 1000L;
    }

    public boolean hasErrorInCase(File localFile) {
        if (!(localFile = this.normalize(localFile.getAbsolutePath())).exists()) {
            return false;
        }
        final String localFileName = localFile.getName();
        FilenameFilter ff = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(localFileName) && !name.equals(localFileName);
            }
        };
        String[] names = localFile.getParentFile().list(ff);
        return names != null && names.length == 1;
    }

    public boolean isUpToDate(File source, File dest, long granularity) {
        if (!dest.exists()) {
            return false;
        }
        long sourceTime = source.lastModified();
        long destTime = dest.lastModified();
        return this.isUpToDate(sourceTime, destTime, granularity);
    }

    public boolean isUpToDate(File source, File dest) {
        return this.isUpToDate(source, dest, this.getFileTimestampGranularity());
    }

    public boolean isUpToDate(long sourceTime, long destTime, long granularity) {
        return destTime != -1L && destTime >= sourceTime + granularity;
    }

    public boolean isUpToDate(long sourceTime, long destTime) {
        return this.isUpToDate(sourceTime, destTime, this.getFileTimestampGranularity());
    }

    public static void close(Writer device) {
        if (null != device) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader device) {
        if (null != device) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream device) {
        if (null != device) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream device) {
        if (null != device) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(File file) {
        if (file != null) {
            file.delete();
        }
    }

    public static String getRelativePath(File fromFile, File toFile) throws Exception {
        int i;
        String fromPath = fromFile.getCanonicalPath();
        String toPath = toFile.getCanonicalPath();
        String[] fromPathStack = FileUtils.getPathStack(fromPath);
        String[] toPathStack = FileUtils.getPathStack(toPath);
        if (0 < toPathStack.length && 0 < fromPathStack.length) {
            if (!fromPathStack[0].equals(toPathStack[0])) {
                return FileUtils.getPath(Arrays.asList(toPathStack));
            }
        } else {
            return FileUtils.getPath(Arrays.asList(toPathStack));
        }
        int minLength = Math.min(fromPathStack.length, toPathStack.length);
        for (int same = 1; same < minLength && fromPathStack[same].equals(toPathStack[same]); ++same) {
        }
        ArrayList<String> relativePathStack = new ArrayList<String>();
        for (i = same; i < fromPathStack.length; ++i) {
            relativePathStack.add("..");
        }
        for (i = same; i < toPathStack.length; ++i) {
            relativePathStack.add(toPathStack[i]);
        }
        return FileUtils.getPath(relativePathStack);
    }

    public static String[] getPathStack(String path) {
        String normalizedPath = path.replace(File.separatorChar, '/');
        Object[] tokens = StringUtils.split(normalizedPath, 47).toArray();
        String[] rv = new String[tokens.length];
        System.arraycopy(tokens, 0, rv, 0, tokens.length);
        return rv;
    }

    public static String getPath(List pathStack) {
        return FileUtils.getPath(pathStack, '/');
    }

    public static String getPath(List pathStack, char separatorChar) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = pathStack.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next());
        }
        while (iter.hasNext()) {
            buffer.append(separatorChar);
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultEncoding() {
        InputStreamReader is = new InputStreamReader(new InputStream(){

            public int read() {
                return -1;
            }
        });
        try {
            String string = is.getEncoding();
            return string;
        }
        finally {
            FileUtils.close(is);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

