/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.manifest;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;

public final class ManifestUtil {
    private static final Comparator<Attributes.Name> nameComparator = Comparator.comparing(Attributes.Name::toString, String.CASE_INSENSITIVE_ORDER);
    private static final Attributes.Name NAME = new Attributes.Name("Name");
    private static final byte[] EOL = new byte[]{13, 10};
    private static final byte[] SEPARATOR = new byte[]{58, 32};
    private static final int MAX_LENGTH = 72 - EOL.length;

    private ManifestUtil() {
    }

    public static void write(Manifest manifest, OutputStream out) throws IOException {
        Attributes mainAttributes = manifest.getMainAttributes();
        Stream<Map.Entry<Attributes.Name, String>> sortedAttributes = ManifestUtil.sortedAttributes(mainAttributes);
        Attributes.Name versionName = Attributes.Name.MANIFEST_VERSION;
        String versionValue = mainAttributes.getValue(versionName);
        if (versionValue == null) {
            versionName = Attributes.Name.SIGNATURE_VERSION;
            versionValue = mainAttributes.getValue(versionName);
        }
        if (versionValue != null) {
            ManifestUtil.writeEntry(out, versionName, versionValue);
            Attributes.Name filterName = versionName;
            sortedAttributes = sortedAttributes.filter(e -> !Objects.equals(e.getKey(), filterName));
        }
        ManifestUtil.writeAttributes(out, sortedAttributes);
        out.write(EOL);
        Iterator iterator = manifest.getEntries().entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ManifestUtil.writeEntry(out, NAME, (String)entry.getKey());
            ManifestUtil.writeAttributes(out, ManifestUtil.sortedAttributes((Attributes)entry.getValue()));
            out.write(EOL);
        }
        out.flush();
    }

    private static void writeEntry(OutputStream out, Attributes.Name name, String value) throws IOException {
        int width = ManifestUtil.write(out, 0, name.toString());
        width = ManifestUtil.write(out, width, SEPARATOR);
        ManifestUtil.write(out, width, value);
        out.write(EOL);
    }

    private static int write(OutputStream out, int width, String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return ManifestUtil.write(out, width, bytes);
    }

    private static int write(OutputStream out, int width, byte[] bytes) throws IOException {
        int remaining;
        int position = 0;
        int limit = bytes.length;
        while ((remaining = limit - position) > 0) {
            if (width >= MAX_LENGTH) {
                out.write(EOL);
                out.write(32);
                width = 1;
            }
            int count = Math.min(MAX_LENGTH - width, remaining);
            out.write(bytes, position, count);
            position += count;
            width += count;
        }
        return width;
    }

    private static void writeAttributes(OutputStream out, Stream<Map.Entry<Attributes.Name, String>> attributes) throws IOException {
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Map.Entry attribute = (Map.Entry)iterator.next();
            ManifestUtil.writeEntry(out, (Attributes.Name)attribute.getKey(), (String)attribute.getValue());
        }
    }

    private static Stream<Map.Entry<Attributes.Name, String>> sortedAttributes(Attributes attributes) {
        Stream<Map.Entry<Attributes.Name, String>> sorted = ManifestUtil.coerce(attributes).entrySet().stream().sorted(Map.Entry.comparingByKey(nameComparator));
        return sorted;
    }

    private static Map<Attributes.Name, String> coerce(Attributes attributes) {
        return attributes;
    }
}

