/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.maven.plugin.AbstractBndMavenPlugin;
import aQute.bnd.maven.plugin.TestCases;
import aQute.bnd.osgi.Builder;
import java.io.File;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="bnd-process-tests", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class BndMavenTestsPlugin
extends AbstractBndMavenPlugin {
    @Parameter(defaultValue="false")
    private boolean artifactFragment;
    @Parameter(defaultValue="junit5")
    private TestCases testCases;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.testResources}", readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=false)
    private File mainClassesDir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    private File classesDir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    private File outputDir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}/META-INF/MANIFEST.MF", readonly=true)
    private File manifestPath;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd-tests.skip", defaultValue="false")
    private boolean skipGoal;

    @Override
    public File getSourceDir() {
        return this.sourceDir;
    }

    @Override
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public File getClassesDir() {
        return this.classesDir;
    }

    @Override
    public File getOutputDir() {
        return this.outputDir;
    }

    @Override
    public File getManifestPath() {
        return this.manifestPath;
    }

    @Override
    public boolean isSkip() {
        return this.skip || this.skipGoal;
    }

    @Override
    protected void processBuildPath(List<Object> buildpath) {
        if (!this.isEmpty(this.mainClassesDir)) {
            buildpath.add(0, this.mainClassesDir);
        }
    }

    @Override
    protected void processBuilder(Builder builder) throws MojoFailureException {
        String defaultBsn = this.project.getArtifactId();
        String bsn = builder.getProperty("Bundle-SymbolicName", defaultBsn + "-tests");
        builder.setProperty("Bundle-SymbolicName", bsn);
        if (this.artifactFragment) {
            String fragmentHost = builder.getProperty("Fragment-Host", defaultBsn);
            builder.setProperty("Fragment-Host", fragmentHost);
        }
        if (this.testCases != TestCases.useTestCasesHeader) {
            builder.setProperty("Test-Cases", "${sort;${uniq;" + this.testCases.filter() + "}}");
        } else if (builder.getUnexpandedProperty("Test-Cases") == null) {
            throw new MojoFailureException("<testCases> specified " + (Object)((Object)TestCases.useTestCasesHeader) + " but no Test-Cases header was found");
        }
    }

    @Override
    protected void reportErrorsAndWarnings(Builder builder) throws MojoFailureException {
        if (builder.getProperty("Test-Cases", "").trim().isEmpty()) {
            builder.warning("The Test-Cases header is empty. No test case classes were found.", new Object[0]);
        }
        super.reportErrorsAndWarnings(builder);
    }
}

