/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler;

import biz.gabrys.lesscss.compiler.CompilerException;
import biz.gabrys.lesscss.compiler.CompilerOptions;
import biz.gabrys.lesscss.compiler.LessCompiler;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.control.processor.PostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.provider.SourceFileProvider;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import java.io.File;

public class SimpleExtendedCompiler
implements ExtendedCompiler {
    protected LessCompiler compiler;
    protected PreCompilationProcessor preProcessor;
    protected SourceFileProvider fileProvider;
    protected PostCompilationProcessor postProcessor;

    public SimpleExtendedCompiler(LessCompiler compiler, PreCompilationProcessor preProcessor, SourceFileProvider fileProvider, PostCompilationProcessor postProcessor) {
        this.compiler = compiler;
        this.preProcessor = preProcessor;
        this.fileProvider = fileProvider;
        this.postProcessor = postProcessor;
    }

    public String compile(LessSource source) throws CompilerException {
        this.preProcessor.prepare(source);
        File sourceFile = this.fileProvider.getFile(source);
        String compiledCode = this.compiler.compile(sourceFile);
        return this.postProcessor.prepare(source, compiledCode);
    }

    public String compile(LessSource source, CompilerOptions options) throws CompilerException {
        this.preProcessor.prepare(source);
        File sourceFile = this.fileProvider.getFile(source);
        String compiledCode = this.compiler.compile(sourceFile, options);
        return this.postProcessor.prepare(source, compiledCode);
    }
}

