/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.control.expiration;

import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledSourceExpirationCheckerImpl
implements CompiledSourceExpirationChecker {
    protected SourceExpirationChecker expirationChecker;
    protected SourceModificationDateCache datesCache;
    protected SourceImportsCache importsCache;
    protected SourceFactory sourceFactory;

    public CompiledSourceExpirationCheckerImpl(SourceExpirationChecker expirationChecker, SourceModificationDateCache datesCache, SourceImportsCache importsCache, SourceFactory sourceFactory) {
        this.expirationChecker = expirationChecker;
        this.datesCache = datesCache;
        this.importsCache = importsCache;
        this.sourceFactory = sourceFactory;
    }

    @Override
    public boolean isExpired(LessSource source, Date lastCompilationDate) {
        return this.isExpired(source, lastCompilationDate, new HashSet<String>());
    }

    protected boolean isExpired(LessSource source, Date lastCompilationDate, Set<String> checkedSourcesPaths) {
        if (this.expirationChecker.isExpired(source) || this.isModifiedAfterLastCompilation(source, lastCompilationDate)) {
            return true;
        }
        checkedSourcesPaths.add(source.getPath());
        return this.checkImports(source, lastCompilationDate, checkedSourcesPaths);
    }

    protected boolean isModifiedAfterLastCompilation(LessSource source, Date lastCompilationDate) {
        Date modificationDate = this.datesCache.getSourceModificationDate(source);
        return modificationDate.after(lastCompilationDate);
    }

    private boolean checkImports(LessSource source, Date lastCompilationDate, Set<String> checkedSourcesPaths) {
        for (String importPath : this.importsCache.getSourceImports(source)) {
            LessSource importedSource = this.sourceFactory.create(source, importPath);
            if (checkedSourcesPaths.contains(importedSource.getPath()) || !this.isExpired(importedSource, lastCompilationDate, checkedSourcesPaths)) continue;
            return true;
        }
        return false;
    }
}

