/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.control.processor;

import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.PreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceTreePreparationProcessor
implements PreCompilationProcessor {
    protected SourceExpirationChecker expirationChecker;
    protected SourceImportsCache importsCache;
    protected SourceFactory sourceFactory;

    protected AbstractSourceTreePreparationProcessor(SourceExpirationChecker expirationChecker, SourceImportsCache importsCache, SourceFactory sourceFactory) {
        this.expirationChecker = expirationChecker;
        this.importsCache = importsCache;
        this.sourceFactory = sourceFactory;
    }

    @Override
    public void prepare(LessSource source) {
        this.prepare(source, new HashSet<String>());
    }

    protected void prepare(LessSource source, Set<String> preparedSourcesPaths) {
        String path = source.getPath();
        if (preparedSourcesPaths.contains(path)) {
            return;
        }
        preparedSourcesPaths.add(path);
        if (this.expirationChecker.isExpired(source)) {
            this.prepareWhenExpired(source, preparedSourcesPaths);
        } else {
            for (String importPath : this.importsCache.getSourceImports(source)) {
                LessSource importedSource = this.sourceFactory.create(source, importPath);
                this.prepare(importedSource, preparedSourcesPaths);
            }
        }
    }

    protected abstract void prepareWhenExpired(LessSource var1, Set<String> var2);
}

