/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.control.processor;

import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.AbstractSourceTreePreparationProcessor;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportOperation;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceTreePreparationProcessor
extends AbstractSourceTreePreparationProcessor {
    protected SourceModificationDateCache datesCache;
    protected LessImportResolver importResolver;

    public SourceTreePreparationProcessor(SourceExpirationChecker expirationChecker, SourceModificationDateCache datesCache, SourceImportsCache importsCache, LessImportResolver importResolver, SourceFactory sourceFactory) {
        super(expirationChecker, importsCache, sourceFactory);
        this.datesCache = datesCache;
        this.importResolver = importResolver;
    }

    @Override
    protected void prepareWhenExpired(LessSource source, Set<String> preparedSourcesPaths) {
        String sourceCode = source.getContent();
        this.datesCache.saveSourceModificationDate(source, source.getLastModificationDate());
        List<LessImportOperation> operations = this.importResolver.resolve(sourceCode);
        ArrayList<String> imports = new ArrayList<String>(operations.size());
        for (LessImportOperation operation : operations) {
            LessSource importSource = this.sourceFactory.create(source, operation.getComputedPath());
            imports.add(operation.getComputedPath());
            this.prepare(importSource, preparedSourcesPaths);
        }
        this.importsCache.saveSourceImports(source, imports);
    }
}

