/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.control.processor;

import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceAlwaysExpiredChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.SourceTreeWithCodeCachingPreparationProcessor;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacer;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacerImpl;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolverImpl;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryBuilder;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;

public class SourceTreeWithCodeCachingPreparationProcessorBuilder {
    private final SourceModificationDateCache datesCache;
    private final SourceImportsCache importsCache;
    private final SourceCodeCache codeCache;
    private SourceExpirationChecker expirationChecker;
    private LessImportResolver importResolver;
    private LessImportReplacer importReplacer;
    private SourceFactory sourceFactory;

    public SourceTreeWithCodeCachingPreparationProcessorBuilder(FullCache cache) {
        ParameterUtils.verifyNotNull("cache", cache);
        this.datesCache = cache;
        this.importsCache = cache;
        this.codeCache = cache;
    }

    public SourceTreeWithCodeCachingPreparationProcessorBuilder(SourceModificationDateCache datesCache, SourceImportsCache importsCache, SourceCodeCache codeCache) {
        ParameterUtils.verifyNotNull("dates cache", datesCache);
        ParameterUtils.verifyNotNull("imports cache", importsCache);
        ParameterUtils.verifyNotNull("code cache", codeCache);
        this.datesCache = datesCache;
        this.importsCache = importsCache;
        this.codeCache = codeCache;
    }

    public SourceTreeWithCodeCachingPreparationProcessorBuilder withExpirationChecker(SourceExpirationChecker expirationChecker) {
        this.expirationChecker = expirationChecker;
        return this;
    }

    public SourceTreeWithCodeCachingPreparationProcessorBuilder withImportResolver(LessImportResolver importResolver) {
        this.importResolver = importResolver;
        return this;
    }

    public SourceTreeWithCodeCachingPreparationProcessorBuilder withImportReplacer(LessImportReplacer importReplacer) {
        this.importReplacer = importReplacer;
        return this;
    }

    public SourceTreeWithCodeCachingPreparationProcessorBuilder withSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
        return this;
    }

    public SourceTreeWithCodeCachingPreparationProcessor create() {
        SourceExpirationChecker checker = this.createExpirationChecker();
        LessImportResolver resolver = this.createImportResolver();
        LessImportReplacer replacer = this.createImportReplacer();
        SourceFactory factory = this.createSourceFactory();
        return new SourceTreeWithCodeCachingPreparationProcessor(checker, this.datesCache, this.importsCache, this.codeCache, resolver, replacer, factory);
    }

    SourceExpirationChecker createExpirationChecker() {
        return this.expirationChecker != null ? this.expirationChecker : new SourceAlwaysExpiredChecker();
    }

    LessImportResolver createImportResolver() {
        return this.importResolver != null ? this.importResolver : new LessImportResolverImpl();
    }

    LessImportReplacer createImportReplacer() {
        return this.importReplacer != null ? this.importReplacer : new LessImportReplacerImpl();
    }

    SourceFactory createSourceFactory() {
        return this.sourceFactory != null ? this.sourceFactory : this.createSourceFactoryFromBuilder(new SourceFactoryBuilder());
    }

    SourceFactory createSourceFactoryFromBuilder(SourceFactoryBuilder builder) {
        return builder.withStandard().create();
    }
}

