/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class ClasspathSource
implements LessSource {
    protected static final String PROTOCOL_PREFIX = "classpath://";
    private final URI uri;
    private final String path;
    private final String encoding;
    private Date lastModificationDate;

    public ClasspathSource(URI uri) {
        this(uri, Charset.defaultCharset().toString());
    }

    public ClasspathSource(URI uri, String encoding) {
        this.uri = uri;
        this.path = uri.toString().substring(PROTOCOL_PREFIX.length());
        this.encoding = encoding;
    }

    public String getPath() {
        return this.uri.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getContent() {
        String content;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = classLoader.getResourceAsStream(this.path);
        if (stream == null) {
            throw new SourceException(String.format("Cannot find resource \"%s\" in classpath", this.path));
        }
        try {
            content = IOUtils.toString((InputStream)stream, (String)this.encoding);
        }
        catch (IOException e) {
            throw new SourceException(String.format("Cannot read content of the \"%s\" resource", this.path), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        this.lastModificationDate = this.getModificationDate();
        return content;
    }

    public Date getLastModificationDate() {
        if (this.lastModificationDate != null) {
            return (Date)this.lastModificationDate.clone();
        }
        return this.getModificationDate();
    }

    private Date getModificationDate() {
        URLConnection connection;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(this.path);
        if (resource == null) {
            throw new SourceException(String.format("Cannot find resource \"%s\" in classpath", this.path));
        }
        try {
            connection = resource.openConnection();
        }
        catch (IOException e) {
            throw new SourceException(String.format("Cannot read last modification date for \"%s\" resource", this.path), e);
        }
        return new Date(connection.getLastModified());
    }
}

