/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class LocalSource
implements LessSource {
    private final File file;
    private final String encoding;
    private Date lastModificationDate;

    public LocalSource(File file) {
        this(file, Charset.defaultCharset().toString());
    }

    public LocalSource(File file, String encoding) {
        this.file = file;
        this.encoding = encoding;
    }

    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new SourceException(String.format("Cannot resolve canonical path for \"%s\" file", this.file.getAbsolutePath()), e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getContent() {
        String content;
        try {
            content = FileUtils.readFileToString((File)this.file, (String)this.encoding);
        }
        catch (IOException e) {
            throw new SourceException(String.format("Cannot read content of the \"%s\" file", this.file.getAbsolutePath()), e);
        }
        this.lastModificationDate = new Date(this.file.lastModified());
        return content;
    }

    public Date getLastModificationDate() {
        if (this.lastModificationDate != null) {
            return (Date)this.lastModificationDate.clone();
        }
        return new Date(this.file.lastModified());
    }

    public static boolean isAbsolutePath(String path) {
        return LocalSource.isAbsolutePath(path, SystemUtils.IS_OS_WINDOWS);
    }

    static boolean isAbsolutePath(String path, boolean windowsOperatingSystem) {
        if (path != null && path.indexOf(0) > -1) {
            return false;
        }
        String normalizedPath = FilenameUtils.normalize((String)path, (boolean)true);
        if (StringUtils.isEmpty((CharSequence)normalizedPath)) {
            return false;
        }
        return LocalSource.isAbsoluteNormalizedPath(normalizedPath, windowsOperatingSystem);
    }

    static boolean isAbsoluteNormalizedPath(String normalizedPath, boolean windowsOperatingSystem) {
        int separator = 47;
        char firstChar = normalizedPath.charAt(0);
        if (!windowsOperatingSystem) {
            return firstChar == '/';
        }
        if (!Character.isLetter(firstChar)) {
            return false;
        }
        int colonIndex = normalizedPath.indexOf(58);
        int separatorIndex = 2;
        return colonIndex == 1 && normalizedPath.length() > 2 && normalizedPath.charAt(2) == '/';
    }
}

