/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.ConcreteSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.LocalSource;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSourceFactory
implements ConcreteSourceFactory<LocalSource> {
    @Override
    public LocalSource createAbsoluteSource(LessSource source, String importAbsolutePath) {
        LocalSourceFactory.validatePath(importAbsolutePath);
        return new LocalSource(new File(importAbsolutePath), source.getEncoding());
    }

    @Override
    public LocalSource createRelativeSource(LessSource source, String importRelativePath) {
        File sourceFile = new File(source.getPath());
        File importFile = new File(sourceFile.getParent(), importRelativePath);
        LocalSourceFactory.validatePath(importFile.getPath());
        return new LocalSource(importFile, source.getEncoding());
    }

    private static void validatePath(String path) {
        if (path != null && path.indexOf(0) > -1) {
            throw new SecurityException("Path contains NULL bytes");
        }
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return LocalSource.isAbsolutePath(path) && new File(path).exists();
    }
}

