/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.ConcreteSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFactoryImpl
implements SourceFactory {
    private final List<ConcreteSourceFactory<? extends LessSource>> factories = new ArrayList<ConcreteSourceFactory<? extends LessSource>>();

    public SourceFactoryImpl(Iterable<ConcreteSourceFactory<? extends LessSource>> factories) {
        for (ConcreteSourceFactory<? extends LessSource> factory : factories) {
            this.factories.add(factory);
        }
    }

    @Override
    public LessSource create(LessSource source, String importPath) {
        for (ConcreteSourceFactory<? extends LessSource> factory : this.factories) {
            if (!factory.isAbsolutePath(importPath)) continue;
            return factory.createAbsoluteSource(source, importPath);
        }
        for (ConcreteSourceFactory<? extends LessSource> factory : this.factories) {
            if (!factory.isAbsolutePath(source.getPath())) continue;
            return factory.createRelativeSource(source, importPath);
        }
        throw new SourceFactoryException(String.format("Cannot create import \"%s\" for source %s with path: %s", importPath, source.getClass().getSimpleName(), source.getPath()));
    }
}

