/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.crmf;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.ProofOfPossession;

public class CertReqMsg
extends ASN1Encodable {
    private CertRequest certReq;
    private ProofOfPossession pop;
    private ASN1Sequence regInfo;

    private CertReqMsg(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.certReq = CertRequest.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof ASN1TaggedObject) {
                this.pop = ProofOfPossession.getInstance(e);
                continue;
            }
            this.regInfo = ASN1Sequence.getInstance(e);
        }
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(aSN1Encodable);
        }
    }

    public CertRequest getCertReq() {
        return this.certReq;
    }

    public static CertReqMsg getInstance(Object object) {
        if (object instanceof CertReqMsg) {
            return (CertReqMsg)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertReqMsg((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public ProofOfPossession getPop() {
        return this.pop;
    }

    public AttributeTypeAndValue[] getRegInfo() {
        if (this.regInfo == null) {
            return null;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[this.regInfo.size()];
        int n = 0;
        while (n != attributeTypeAndValueArray.length) {
            attributeTypeAndValueArray[n] = AttributeTypeAndValue.getInstance(this.regInfo.getObjectAt(n));
            ++n;
        }
        return attributeTypeAndValueArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.certReq);
        this.addOptional(aSN1EncodableVector, this.pop);
        this.addOptional(aSN1EncodableVector, this.regInfo);
        return new DERSequence(aSN1EncodableVector);
    }
}

