/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ess;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Encodable {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public SigningCertificateV2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.certs = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.policies = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n < eSSCertIDv2Array.length) {
            aSN1EncodableVector.add(eSSCertIDv2Array[n]);
            ++n;
        }
        this.certs = new DERSequence(aSN1EncodableVector);
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array, PolicyInformation[] policyInformationArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n < eSSCertIDv2Array.length) {
            aSN1EncodableVector.add(eSSCertIDv2Array[n]);
            ++n;
        }
        this.certs = new DERSequence(aSN1EncodableVector);
        if (policyInformationArray != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            int n2 = 0;
            while (n2 < policyInformationArray.length) {
                aSN1EncodableVector.add(policyInformationArray[n2]);
                ++n2;
            }
            this.policies = new DERSequence(aSN1EncodableVector);
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[this.certs.size()];
        int n = 0;
        while (n != this.certs.size()) {
            eSSCertIDv2Array[n] = ESSCertIDv2.getInstance(this.certs.getObjectAt(n));
            ++n;
        }
        return eSSCertIDv2Array;
    }

    public static SigningCertificateV2 getInstance(Object object) {
        if (object == null || object instanceof SigningCertificateV2) {
            return (SigningCertificateV2)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SigningCertificateV2((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'SigningCertificateV2' factory : " + object.getClass().getName() + ".");
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.policies.size()];
        int n = 0;
        while (n != this.policies.size()) {
            policyInformationArray[n] = PolicyInformation.getInstance(this.policies.getObjectAt(n));
            ++n;
        }
        return policyInformationArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.certs);
        if (this.policies != null) {
            aSN1EncodableVector.add(this.policies);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

