/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extension;

public class AuthorityInformationAccess
extends ASN1Encodable {
    private AccessDescription[] descriptions;

    public AuthorityInformationAccess(ASN1Sequence aSN1Sequence) {
        this.descriptions = new AccessDescription[aSN1Sequence.size()];
        int n = 0;
        while (n != aSN1Sequence.size()) {
            this.descriptions[n] = AccessDescription.getInstance(aSN1Sequence.getObjectAt(n));
            ++n;
        }
    }

    public AuthorityInformationAccess(DERObjectIdentifier dERObjectIdentifier, GeneralName generalName) {
        this.descriptions = new AccessDescription[1];
        this.descriptions[0] = new AccessDescription(dERObjectIdentifier, generalName);
    }

    public AccessDescription[] getAccessDescriptions() {
        return this.descriptions;
    }

    public static AuthorityInformationAccess getInstance(Object object) {
        if (object instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthorityInformationAccess((ASN1Sequence)object);
        }
        if (object instanceof X509Extension) {
            return AuthorityInformationAccess.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n != this.descriptions.length) {
            aSN1EncodableVector.add(this.descriptions[n]);
            ++n;
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.descriptions[0].getAccessMethod().getId() + ")";
    }
}

