/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;

class DHParametersHelper {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    DHParametersHelper() {
    }

    private static BigInteger createInRange(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        while ((bigInteger3 = new BigInteger(bigInteger2.bitLength(), secureRandom)).compareTo(bigInteger) < 0 || bigInteger3.compareTo(bigInteger2) > 0) {
        }
        return bigInteger3;
    }

    static BigInteger[] generateSafePrimes(int n, int n2, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n3 = n - 1;
        while (!(bigInteger2 = (bigInteger = new BigInteger(n3, 2, secureRandom)).shiftLeft(1).add(ONE)).isProbablePrime(n2) || n2 > 2 && !bigInteger.isProbablePrime(n2)) {
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    static BigInteger selectGenerator(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger.subtract(TWO);
        while ((bigInteger3 = DHParametersHelper.createInRange(TWO, bigInteger4, secureRandom)).modPow(TWO, bigInteger).equals(ONE) || bigInteger3.modPow(bigInteger2, bigInteger).equals(ONE)) {
        }
        return bigInteger3;
    }
}

