/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSABlindingParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private int hLen;
    private int sLen;
    private int emBits;
    private byte[] salt;
    private byte[] mDash;
    private byte[] block;
    private byte trailer;

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n) {
        this(asymmetricBlockCipher, digest, n, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n, byte by) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        this.hLen = digest.getDigestSize();
        this.sLen = n;
        this.salt = new byte[n];
        this.mDash = new byte[8 + n + this.hLen];
        this.trailer = by;
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
    }

    private void clearBlock(byte[] byArray) {
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            throw new DataLengthException("encoding error");
        }
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        if (this.sLen != 0) {
            this.random.nextBytes(this.salt);
            System.arraycopy(this.salt, 0, this.mDash, this.mDash.length - this.sLen, this.sLen);
        }
        byte[] byArray = new byte[this.hLen];
        this.digest.update(this.mDash, 0, this.mDash.length);
        this.digest.doFinal(byArray, 0);
        this.block[this.block.length - this.sLen - 1 - this.hLen - 1] = 1;
        System.arraycopy(this.salt, 0, this.block, this.block.length - this.sLen - this.hLen - 1, this.sLen);
        byte[] byArray2 = this.maskGeneratorFunction1(byArray, 0, byArray.length, this.block.length - this.hLen - 1);
        int n = 0;
        while (n != byArray2.length) {
            int n2 = n;
            this.block[n2] = (byte)(this.block[n2] ^ byArray2[n]);
            ++n;
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        System.arraycopy(byArray, 0, this.block, this.block.length - this.hLen - 1, this.hLen);
        this.block[this.block.length - 1] = this.trailer;
        byte[] byArray3 = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.block);
        return byArray3;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        CipherParameters cipherParameters3;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters3 = (ParametersWithRandom)cipherParameters;
            cipherParameters2 = ((ParametersWithRandom)cipherParameters3).getParameters();
            this.random = ((ParametersWithRandom)cipherParameters3).getRandom();
        } else {
            cipherParameters2 = cipherParameters;
            if (bl) {
                this.random = new SecureRandom();
            }
        }
        this.cipher.init(bl, cipherParameters2);
        cipherParameters3 = cipherParameters2 instanceof RSABlindingParameters ? ((RSABlindingParameters)cipherParameters2).getPublicKey() : (RSAKeyParameters)cipherParameters2;
        this.emBits = ((RSAKeyParameters)cipherParameters3).getModulus().bitLength() - 1;
        this.block = new byte[(this.emBits + 7) / 8];
        this.reset();
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[this.hLen];
        byte[] byArray4 = new byte[4];
        int n4 = 0;
        this.digest.reset();
        while (n4 < n3 / this.hLen) {
            this.ItoOSP(n4, byArray4);
            this.digest.update(byArray, n, n2);
            this.digest.update(byArray4, 0, byArray4.length);
            this.digest.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.hLen, this.hLen);
            ++n4;
        }
        if (n4 * this.hLen < n3) {
            this.ItoOSP(n4, byArray4);
            this.digest.update(byArray, n, n2);
            this.digest.update(byArray4, 0, byArray4.length);
            this.digest.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.hLen, byArray2.length - n4 * this.hLen);
        }
        return byArray2;
    }

    public void reset() {
        this.digest.reset();
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2;
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            return false;
        }
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        try {
            byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
            System.arraycopy(byArray2, 0, this.block, this.block.length - byArray2.length, byArray2.length);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.block[this.block.length - 1] != this.trailer) {
            this.clearBlock(this.block);
            return false;
        }
        byArray2 = this.maskGeneratorFunction1(this.block, this.block.length - this.hLen - 1, this.hLen, this.block.length - this.hLen - 1);
        int n = 0;
        while (n != byArray2.length) {
            int n2 = n;
            this.block[n2] = (byte)(this.block[n2] ^ byArray2[n]);
            ++n;
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        int n3 = 0;
        while (n3 != this.block.length - this.hLen - this.sLen - 2) {
            if (this.block[n3] != 0) {
                this.clearBlock(this.block);
                return false;
            }
            ++n3;
        }
        if (this.block[this.block.length - this.hLen - this.sLen - 2] != 1) {
            this.clearBlock(this.block);
            return false;
        }
        System.arraycopy(this.block, this.block.length - this.sLen - this.hLen - 1, this.mDash, this.mDash.length - this.sLen, this.sLen);
        this.digest.update(this.mDash, 0, this.mDash.length);
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen);
        int n4 = this.block.length - this.hLen - 1;
        int n5 = this.mDash.length - this.hLen;
        while (n5 != this.mDash.length) {
            if ((this.block[n4] ^ this.mDash[n5]) != 0) {
                this.clearBlock(this.mDash);
                this.clearBlock(this.block);
                return false;
            }
            ++n4;
            ++n5;
        }
        this.clearBlock(this.mDash);
        this.clearBlock(this.block);
        return true;
    }
}

