/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.jce.provider.RSAUtil;

public class JDKISOSignature
extends Signature {
    private ISO9796d2Signer signer;

    protected JDKISOSignature(String string, Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        super(string);
        this.signer = new ISO9796d2Signer(asymmetricBlockCipher, digest, true);
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, rSAKeyParameters);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.signer.init(false, rSAKeyParameters);
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.signer.generateSignature();
            return byArray;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.signer.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.signer.update(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        boolean bl = this.signer.verifySignature(byArray);
        return bl;
    }

    public static class SHA1WithRSAEncryption
    extends JDKISOSignature {
        public SHA1WithRSAEncryption() {
            super("SHA1withRSA/ISO9796-2", new SHA1Digest(), new RSABlindedEngine());
        }
    }

    public static class MD5WithRSAEncryption
    extends JDKISOSignature {
        public MD5WithRSAEncryption() {
            super("MD5withRSA/ISO9796-2", new MD5Digest(), new RSABlindedEngine());
        }
    }

    public static class RIPEMD160WithRSAEncryption
    extends JDKISOSignature {
        public RIPEMD160WithRSAEncryption() {
            super("RIPEMD160withRSA/ISO9796-2", new RIPEMD160Digest(), new RSABlindedEngine());
        }
    }
}

