/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.util.Random;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.icao.DataGroupHash;
import org.bouncycastle.util.test.SimpleTest;

public class DataGroupHashUnitTest
extends SimpleTest {
    public String getName() {
        return "DataGroupHash";
    }

    private byte[] generateHash() {
        Random random = new Random();
        byte[] byArray = new byte[20];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)random.nextInt();
        }
        return byArray;
    }

    public void performTest() throws Exception {
        int n = 1;
        DEROctetString dEROctetString = new DEROctetString(this.generateHash());
        DataGroupHash dataGroupHash = new DataGroupHash(n, dEROctetString);
        this.checkConstruction(dataGroupHash, n, dEROctetString);
        dataGroupHash = DataGroupHash.getInstance(null);
        if (dataGroupHash != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            DataGroupHash.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(DataGroupHash dataGroupHash, int n, ASN1OctetString aSN1OctetString) throws IOException {
        this.checkValues(dataGroupHash, n, aSN1OctetString);
        dataGroupHash = DataGroupHash.getInstance(dataGroupHash);
        this.checkValues(dataGroupHash, n, aSN1OctetString);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(dataGroupHash.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        dataGroupHash = DataGroupHash.getInstance(aSN1Sequence);
        this.checkValues(dataGroupHash, n, aSN1OctetString);
    }

    private void checkValues(DataGroupHash dataGroupHash, int n, ASN1OctetString aSN1OctetString) {
        if (dataGroupHash.getDataGroupNumber() != n) {
            this.fail("group number don't match.");
        }
        if (!dataGroupHash.getDataGroupHashValue().equals(aSN1OctetString)) {
            this.fail("hash value don't match.");
        }
    }

    public static void main(String[] stringArray) {
        DataGroupHashUnitTest.runTest(new DataGroupHashUnitTest());
    }
}

