/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.CompressedDataParser;
import org.bouncycastle.asn1.cms.ContentInfoParser;

public class OctetStringTest
extends TestCase {
    public void testReadingWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(byteArrayOutputStream);
        OutputStream outputStream = bEROctetStringGenerator.getOctetOutputStream();
        outputStream.write(new byte[]{1, 2, 3, 4});
        outputStream.write(new byte[4]);
        outputStream.close();
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(byteArrayOutputStream.toByteArray());
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)aSN1StreamParser.readObject();
        InputStream inputStream = aSN1OctetStringParser.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        OctetStringTest.assertEquals((int)8, (int)n);
    }

    public void testReadingWritingZeroInLength() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(byteArrayOutputStream);
        OutputStream outputStream = bEROctetStringGenerator.getOctetOutputStream();
        outputStream.write(new byte[]{1, 2, 3, 4});
        outputStream.write(new byte[512]);
        outputStream.close();
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(byteArrayOutputStream.toByteArray());
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)aSN1StreamParser.readObject();
        InputStream inputStream = aSN1OctetStringParser.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        OctetStringTest.assertEquals((int)516, (int)n);
    }

    public void testReadingWritingNested() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(byteArrayOutputStream);
        BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(bERSequenceGenerator.getRawOutputStream());
        OutputStream outputStream = bEROctetStringGenerator.getOctetOutputStream();
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(outputStream);
        BEROctetStringGenerator bEROctetStringGenerator2 = new BEROctetStringGenerator(bERSequenceGenerator2.getRawOutputStream());
        OutputStream outputStream2 = bEROctetStringGenerator2.getOctetOutputStream();
        outputStream2.write(new byte[]{1, 2, 3, 4});
        outputStream2.write(new byte[10]);
        outputStream2.close();
        bERSequenceGenerator2.close();
        outputStream.close();
        bERSequenceGenerator.close();
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(byteArrayOutputStream.toByteArray());
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)aSN1SequenceParser.readObject();
        ASN1StreamParser aSN1StreamParser2 = new ASN1StreamParser(aSN1OctetStringParser.getOctetStream());
        ASN1SequenceParser aSN1SequenceParser2 = (ASN1SequenceParser)aSN1StreamParser2.readObject();
        ASN1OctetStringParser aSN1OctetStringParser2 = (ASN1OctetStringParser)aSN1SequenceParser2.readObject();
        InputStream inputStream = aSN1OctetStringParser2.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        OctetStringTest.assertEquals((int)14, (int)n);
    }

    public void testNestedStructure() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(byteArrayOutputStream);
        bERSequenceGenerator.addObject(new DERObjectIdentifier(CMSObjectIdentifiers.compressedData.getId()));
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(new DERInteger(0));
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.2"));
        dERSequenceGenerator.close();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(new DERObjectIdentifier("1.1"));
        BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(bERSequenceGenerator3.getRawOutputStream(), 0, true);
        OutputStream outputStream = bEROctetStringGenerator.getOctetOutputStream();
        outputStream.write(new byte[]{1, 2, 3, 4});
        outputStream.write(new byte[4]);
        outputStream.write(new byte[20]);
        outputStream.close();
        bERSequenceGenerator3.close();
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(byteArrayOutputStream.toByteArray());
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        CompressedDataParser compressedDataParser = new CompressedDataParser((ASN1SequenceParser)contentInfoParser.getContent(16));
        ContentInfoParser contentInfoParser2 = compressedDataParser.getEncapContentInfo();
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser2.getContent(4);
        InputStream inputStream = aSN1OctetStringParser.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        OctetStringTest.assertEquals((int)28, (int)n);
    }

    public static Test suite() {
        return new TestSuite(OctetStringTest.class);
    }
}

