/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class X9Test
extends SimpleTest {
    private byte[] namedPub = Base64.decode("MBowEwYHKoZIzj0CAQYIKoZIzj0DAQEDAwADAQ==");
    private byte[] expPub = Base64.decode("MIHcMIHUBgcqhkjOPQIBMIHIAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVEDAwADAQ==");
    private byte[] namedPriv = Base64.decode("MCICAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEECDAGAgEBBAEK");
    private byte[] expPriv = Base64.decode("MIHkAgEAMIHUBgcqhkjOPQIBMIHIAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVEECDAGAgEBBAEU");

    private void encodePublicKey() throws Exception {
        ASN1InputStream aSN1InputStream;
        DERObject dERObject;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(x9ECParameters.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)), true)).getDERObject();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), aSN1OctetString.getOctets());
        if (!this.areEqual(subjectPublicKeyInfo.getEncoded(), this.namedPub)) {
            this.fail("failed public named generation");
        }
        if (!subjectPublicKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.namedPub))).readObject())) {
            this.fail("failed public named equality");
        }
        if (!this.areEqual((subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(x9ECParameters)), aSN1OctetString.getOctets())).getEncoded(), this.expPub)) {
            this.fail("failed public explicit generation");
        }
        if (!subjectPublicKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.expPub))).readObject())) {
            this.fail("failed public explicit equality");
        }
    }

    private void encodePrivateKey() throws Exception {
        ASN1InputStream aSN1InputStream;
        DERObject dERObject;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        X962Parameters x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(x9ECParameters.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)), true)).getDERObject();
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKeyStructure(BigInteger.valueOf(10L)).getDERObject());
        if (!this.areEqual(privateKeyInfo.getEncoded(), this.namedPriv)) {
            this.fail("failed private named generation");
        }
        if (!privateKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.namedPriv))).readObject())) {
            this.fail("failed private named equality");
        }
        if (!this.areEqual((privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(x9ECParameters)), new ECPrivateKeyStructure(BigInteger.valueOf(20L)).toASN1Object())).getEncoded(), this.expPriv)) {
            this.fail("failed private explicit generation");
        }
        if (!privateKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.expPriv))).readObject())) {
            this.fail("failed private explicit equality");
        }
    }

    public void performTest() throws Exception {
        this.encodePublicKey();
        this.encodePrivateKey();
    }

    public String getName() {
        return "X9";
    }

    public static void main(String[] stringArray) {
        X9Test.runTest(new X9Test());
    }
}

