/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.DHAgreement;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.generators.DHParametersGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.test.SimpleTest;

public class DHTest
extends SimpleTest {
    private BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
    private BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
    private BigInteger g768 = new BigInteger("7c240073c1316c621df461b71ebb0cdcc90a6e5527e5e126633d131f87461c4dc4afc60c2cb0f053b6758871489a69613e2a8b4c8acde23954c08c81cbd36132cfd64d69e4ed9f8e51ed6e516297206672d5c0a69135df0a5dcf010d289a9ca1", 16);
    private BigInteger p768 = new BigInteger("8c9dd223debed1b80103b8b309715be009d48860ed5ae9b9d5d8159508efd802e3ad4501a7f7e1cfec78844489148cd72da24b21eddd01aa624291c48393e277cfc529e37075eccef957f3616f962d15b44aeab4039d01b817fde9eaa12fd73f", 16);
    private BigInteger g1024 = new BigInteger("1db17639cdf96bc4eabba19454f0b7e5bd4e14862889a725c96eb61048dcd676ceb303d586e30f060dbafd8a571a39c4d823982117da5cc4e0f89c77388b7a08896362429b94a18a327604eb7ff227bffbc83459ade299e57b5f77b50fb045250934938efa145511166e3197373e1b5b1e52de713eb49792bedde722c6717abf", 16);
    private BigInteger p1024 = new BigInteger("a00e283b3c624e5b2b4d9fbc2653b5185d99499b00fd1bf244c6f0bb817b4d1c451b2958d62a0f8a38caef059fb5ecd25d75ed9af403f5b5bdab97a642902f824e3c13789fed95fa106ddfe0ff4a707c85e2eb77d49e68f2808bcea18ce128b178cd287c6bc00efa9a1ad2a673fe0dceace53166f75b81d6709d5f8af7c66bb7", 16);

    public String getName() {
        return "DH";
    }

    private void testDH(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        DHKeyPairGenerator dHKeyPairGenerator = this.getDHKeyPairGenerator(bigInteger, bigInteger2);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHAgreement dHAgreement = new DHAgreement();
        DHAgreement dHAgreement2 = new DHAgreement();
        dHAgreement.init(dHPrivateKeyParameters);
        dHAgreement2.init(dHPrivateKeyParameters2);
        BigInteger bigInteger3 = dHAgreement.calculateMessage();
        BigInteger bigInteger4 = dHAgreement2.calculateMessage();
        BigInteger bigInteger5 = dHAgreement.calculateAgreement(dHPublicKeyParameters2, bigInteger4);
        BigInteger bigInteger6 = dHAgreement2.calculateAgreement(dHPublicKeyParameters, bigInteger3);
        if (!bigInteger5.equals(bigInteger6)) {
            this.fail(n + " bit 2-way test failed");
        }
    }

    private void testDHBasic(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2) {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = this.getDHBasicKeyPairGenerator(bigInteger, bigInteger2, n2);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.checkKeySize(n2, dHPrivateKeyParameters);
        asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.checkKeySize(n2, dHPrivateKeyParameters2);
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(dHPrivateKeyParameters);
        dHBasicAgreement2.init(dHPrivateKeyParameters2);
        BigInteger bigInteger3 = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters2);
        BigInteger bigInteger4 = dHBasicAgreement2.calculateAgreement(dHPublicKeyParameters);
        if (!bigInteger3.equals(bigInteger4)) {
            this.fail("basic " + n + " bit 2-way test failed");
        }
    }

    private void checkKeySize(int n, DHPrivateKeyParameters dHPrivateKeyParameters) {
        if (n != 0 && dHPrivateKeyParameters.getX().bitLength() != n) {
            this.fail("limited key check failed for key size " + n);
        }
    }

    private void testGPWithRandom(DHKeyPairGenerator dHKeyPairGenerator) {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHAgreement dHAgreement = new DHAgreement();
        DHAgreement dHAgreement2 = new DHAgreement();
        dHAgreement.init(new ParametersWithRandom(dHPrivateKeyParameters, new SecureRandom()));
        dHAgreement2.init(new ParametersWithRandom(dHPrivateKeyParameters2, new SecureRandom()));
        BigInteger bigInteger = dHAgreement.calculateMessage();
        BigInteger bigInteger2 = dHAgreement2.calculateMessage();
        BigInteger bigInteger3 = dHAgreement.calculateAgreement(dHPublicKeyParameters2, bigInteger2);
        BigInteger bigInteger4 = dHAgreement2.calculateAgreement(dHPublicKeyParameters, bigInteger);
        if (!bigInteger3.equals(bigInteger4)) {
            this.fail("basic with random 2-way test failed");
        }
    }

    private void testSimpleWithRandom(DHBasicKeyPairGenerator dHBasicKeyPairGenerator) {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(new ParametersWithRandom(dHPrivateKeyParameters, new SecureRandom()));
        dHBasicAgreement2.init(new ParametersWithRandom(dHPrivateKeyParameters2, new SecureRandom()));
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters2);
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHPublicKeyParameters);
        if (!bigInteger.equals(bigInteger2)) {
            this.fail("basic with random 2-way test failed");
        }
    }

    private DHBasicKeyPairGenerator getDHBasicKeyPairGenerator(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        DHParameters dHParameters = new DHParameters(bigInteger2, bigInteger, null, n);
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(dHKeyGenerationParameters);
        return dHBasicKeyPairGenerator;
    }

    private DHKeyPairGenerator getDHKeyPairGenerator(BigInteger bigInteger, BigInteger bigInteger2) {
        DHParameters dHParameters = new DHParameters(bigInteger2, bigInteger);
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(dHKeyGenerationParameters);
        return dHKeyPairGenerator;
    }

    private void testGeneration(int n) {
        DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
        dHParametersGenerator.init(n, 10, new SecureRandom());
        DHParameters dHParameters = dHParametersGenerator.generateParameters();
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHPublicKeyParameters.getParameters());
        dHBasicKeyPairGenerator.init(dHKeyGenerationParameters);
        asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(new ParametersWithRandom(dHPrivateKeyParameters, new SecureRandom()));
        dHBasicAgreement2.init(new ParametersWithRandom(dHPrivateKeyParameters2, new SecureRandom()));
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters2);
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHPublicKeyParameters);
        if (!bigInteger.equals(bigInteger2)) {
            this.fail("basic with " + n + " bit 2-way test failed");
        }
    }

    public void performTest() {
        this.testDHBasic(512, 0, this.g512, this.p512);
        this.testDHBasic(768, 0, this.g768, this.p768);
        this.testDHBasic(1024, 0, this.g1024, this.p1024);
        this.testDHBasic(512, 64, this.g512, this.p512);
        this.testDHBasic(768, 128, this.g768, this.p768);
        this.testDHBasic(1024, 256, this.g1024, this.p1024);
        this.testDH(512, this.g512, this.p512);
        this.testDH(768, this.g768, this.p768);
        this.testDH(1024, this.g1024, this.p1024);
        this.testGeneration(256);
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = this.getDHBasicKeyPairGenerator(this.g512, this.p512, 0);
        this.testSimpleWithRandom(dHBasicKeyPairGenerator);
        DHKeyPairGenerator dHKeyPairGenerator = this.getDHKeyPairGenerator(this.g512, this.p512);
        this.testGPWithRandom(dHKeyPairGenerator);
        DHAgreement dHAgreement = new DHAgreement();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        try {
            dHAgreement.init(asymmetricCipherKeyPair.getPublic());
            this.fail("DHAgreement key check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DHKeyPairGenerator dHKeyPairGenerator2 = this.getDHKeyPairGenerator(this.g768, this.p768);
        try {
            dHAgreement.init(asymmetricCipherKeyPair.getPrivate());
            dHAgreement.calculateAgreement((DHPublicKeyParameters)dHKeyPairGenerator2.generateKeyPair().getPublic(), BigInteger.valueOf(100L));
            this.fail("DHAgreement agreement check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = dHBasicKeyPairGenerator.generateKeyPair();
        try {
            dHBasicAgreement.init(asymmetricCipherKeyPair2.getPublic());
            this.fail("DHBasicAgreement key check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator2 = this.getDHBasicKeyPairGenerator(this.g768, this.p768, 0);
        try {
            dHBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
            dHBasicAgreement.calculateAgreement((DHPublicKeyParameters)dHBasicKeyPairGenerator2.generateKeyPair().getPublic());
            this.fail("DHBasicAgreement agreement check failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        DHTest.runTest(new DHTest());
    }
}

