/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.util.test.SimpleTest;

public class ShortenedDigestTest
extends SimpleTest {
    public void performTest() {
        ExtendedDigest extendedDigest = new SHA1Digest();
        ShortenedDigest shortenedDigest = new ShortenedDigest(new SHA1Digest(), 10);
        if (shortenedDigest.getDigestSize() != 10) {
            this.fail("size check wrong for SHA-1");
        }
        if (shortenedDigest.getByteLength() != extendedDigest.getByteLength()) {
            this.fail("byte length check wrong for SHA-1");
        }
        shortenedDigest.doFinal(new byte[10], 0);
        extendedDigest = new SHA512Digest();
        shortenedDigest = new ShortenedDigest(new SHA512Digest(), 20);
        if (shortenedDigest.getDigestSize() != 20) {
            this.fail("size check wrong for SHA-512");
        }
        if (shortenedDigest.getByteLength() != extendedDigest.getByteLength()) {
            this.fail("byte length check wrong for SHA-512");
        }
        shortenedDigest.doFinal(new byte[20], 0);
        try {
            new ShortenedDigest(null, 20);
            this.fail("null parameter not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ShortenedDigest(new SHA1Digest(), 50);
            this.fail("short digest not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String getName() {
        return "ShortenedDigest";
    }

    public static void main(String[] stringArray) {
        ShortenedDigestTest.runTest(new ShortenedDigestTest());
    }
}

