/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.util.Random;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.util.test.SimpleTest;

public class BiometricDataUnitTest
extends SimpleTest {
    public String getName() {
        return "BiometricData";
    }

    private byte[] generateHash() {
        Random random = new Random();
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        return byArray;
    }

    public void performTest() throws Exception {
        TypeOfBiometricData typeOfBiometricData = new TypeOfBiometricData(1);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DERNull());
        DEROctetString dEROctetString = new DEROctetString(this.generateHash());
        BiometricData biometricData = new BiometricData(typeOfBiometricData, algorithmIdentifier, dEROctetString);
        this.checkConstruction(biometricData, typeOfBiometricData, algorithmIdentifier, dEROctetString, null);
        DERIA5String dERIA5String = new DERIA5String("http://test");
        biometricData = new BiometricData(typeOfBiometricData, algorithmIdentifier, dEROctetString, dERIA5String);
        this.checkConstruction(biometricData, typeOfBiometricData, algorithmIdentifier, dEROctetString, dERIA5String);
        biometricData = BiometricData.getInstance(null);
        if (biometricData != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            BiometricData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(BiometricData biometricData, TypeOfBiometricData typeOfBiometricData, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString, DERIA5String dERIA5String) throws Exception {
        this.checkValues(biometricData, typeOfBiometricData, algorithmIdentifier, aSN1OctetString, dERIA5String);
        biometricData = BiometricData.getInstance(biometricData);
        this.checkValues(biometricData, typeOfBiometricData, algorithmIdentifier, aSN1OctetString, dERIA5String);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(biometricData.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        biometricData = BiometricData.getInstance(aSN1Sequence);
        this.checkValues(biometricData, typeOfBiometricData, algorithmIdentifier, aSN1OctetString, dERIA5String);
    }

    private void checkValues(BiometricData biometricData, TypeOfBiometricData typeOfBiometricData, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString, DERIA5String dERIA5String) {
        if (!biometricData.getTypeOfBiometricData().equals(typeOfBiometricData)) {
            this.fail("types don't match.");
        }
        if (!biometricData.getHashAlgorithm().equals(algorithmIdentifier)) {
            this.fail("hash algorithms don't match.");
        }
        if (!biometricData.getBiometricDataHash().equals(aSN1OctetString)) {
            this.fail("hash algorithms don't match.");
        }
        if (dERIA5String != null) {
            if (!biometricData.getSourceDataUri().equals(dERIA5String)) {
                this.fail("data uris don't match.");
            }
        } else if (biometricData.getSourceDataUri() != null) {
            this.fail("data uri found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        BiometricDataUnitTest.runTest(new BiometricDataUnitTest());
    }
}

