/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.RFC3739QCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import org.bouncycastle.util.test.SimpleTest;

public class QCStatementUnitTest
extends SimpleTest {
    public String getName() {
        return "QCStatement";
    }

    public void performTest() throws Exception {
        QCStatement qCStatement = new QCStatement(RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v1);
        this.checkConstruction(qCStatement, RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v1, null);
        SemanticsInformation semanticsInformation = new SemanticsInformation(new DERObjectIdentifier("1.2"));
        qCStatement = new QCStatement(RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v1, semanticsInformation);
        this.checkConstruction(qCStatement, RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v1, semanticsInformation);
        qCStatement = QCStatement.getInstance(null);
        if (qCStatement != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            QCStatement.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(QCStatement qCStatement, DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        this.checkStatement(qCStatement, dERObjectIdentifier, aSN1Encodable);
        qCStatement = QCStatement.getInstance(qCStatement);
        this.checkStatement(qCStatement, dERObjectIdentifier, aSN1Encodable);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(qCStatement.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        qCStatement = QCStatement.getInstance(aSN1Sequence);
        this.checkStatement(qCStatement, dERObjectIdentifier, aSN1Encodable);
    }

    private void checkStatement(QCStatement qCStatement, DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        if (!qCStatement.getStatementId().equals(dERObjectIdentifier)) {
            this.fail("statementIds don't match.");
        }
        if (aSN1Encodable != null) {
            if (!qCStatement.getStatementInfo().equals(aSN1Encodable)) {
                this.fail("statementInfos don't match.");
            }
        } else if (qCStatement.getStatementInfo() != null) {
            this.fail("statementInfo found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        QCStatementUnitTest.runTest(new QCStatementUnitTest());
    }
}

