/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS12Test
implements Test {
    char[] password1 = new char[]{'s', 'm', 'e', 'g'};
    char[] password2 = new char[]{'q', 'u', 'e', 'e', 'g'};

    private boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private TestResult run1(int n, char[] cArray, byte[] byArray, int n2, byte[] byArray2) {
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
        pKCS12ParametersGenerator.init(PBEParametersGenerator.PKCS12PasswordToBytes(cArray), byArray, n2);
        CipherParameters cipherParameters = ((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedParameters(192);
        if (this.isEqual(byArray2, ((KeyParameter)cipherParameters).getKey())) {
            return new SimpleTestResult(true, "PKCS12Test: Okay");
        }
        return new SimpleTestResult(false, "PKCS12Test: id " + n + " Failed");
    }

    private TestResult run2(int n, char[] cArray, byte[] byArray, int n2, byte[] byArray2) {
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
        pKCS12ParametersGenerator.init(PBEParametersGenerator.PKCS12PasswordToBytes(cArray), byArray, n2);
        ParametersWithIV parametersWithIV = (ParametersWithIV)((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedParameters(64, 64);
        if (this.isEqual(byArray2, parametersWithIV.getIV())) {
            return new SimpleTestResult(true, "PKCS12Test: Okay");
        }
        return new SimpleTestResult(false, "PKCS12Test: id " + n + " Failed");
    }

    private TestResult run3(int n, char[] cArray, byte[] byArray, int n2, byte[] byArray2) {
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
        pKCS12ParametersGenerator.init(PBEParametersGenerator.PKCS12PasswordToBytes(cArray), byArray, n2);
        CipherParameters cipherParameters = ((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedMacParameters(160);
        if (this.isEqual(byArray2, ((KeyParameter)cipherParameters).getKey())) {
            return new SimpleTestResult(true, "PKCS12Test: Okay");
        }
        return new SimpleTestResult(false, "PKCS12Test: id " + n + " Failed");
    }

    public String getName() {
        return "PKCS12Test";
    }

    public TestResult perform() {
        TestResult testResult = this.run1(1, this.password1, Hex.decode("0A58CF64530D823F"), 1, Hex.decode("8AAAE6297B6CB04642AB5B077851284EB7128F1A2A7FBCA3"));
        if (testResult.isSuccessful()) {
            testResult = this.run2(2, this.password1, Hex.decode("0A58CF64530D823F"), 1, Hex.decode("79993DFE048D3B76"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run1(3, this.password1, Hex.decode("642B99AB44FB4B1F"), 1, Hex.decode("F3A95FEC48D7711E985CFE67908C5AB79FA3D7C5CAA5D966"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run2(4, this.password1, Hex.decode("642B99AB44FB4B1F"), 1, Hex.decode("C0A38D64A79BEA1D"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run3(5, this.password1, Hex.decode("3D83C0E4546AC140"), 1, Hex.decode("8D967D88F6CAA9D714800AB3D48051D63F73A312"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run1(6, this.password2, Hex.decode("05DEC959ACFF72F7"), 1000, Hex.decode("ED2034E36328830FF09DF1E1A07DD357185DAC0D4F9EB3D4"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run2(7, this.password2, Hex.decode("05DEC959ACFF72F7"), 1000, Hex.decode("11DEDAD7758D4860"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run1(8, this.password2, Hex.decode("1682C0FC5B3F7EC5"), 1000, Hex.decode("483DD6E919D7DE2E8E648BA8F862F3FBFBDC2BCB2C02957F"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run2(9, this.password2, Hex.decode("1682C0FC5B3F7EC5"), 1000, Hex.decode("9D461D1B00355C50"));
        }
        if (testResult.isSuccessful()) {
            testResult = this.run3(10, this.password2, Hex.decode("263216FCC2FAB31C"), 1000, Hex.decode("5EC4C7A80DF652294C3925B6489A7AB857C83476"));
        }
        return testResult;
    }

    public static void main(String[] stringArray) {
        PKCS12Test pKCS12Test = new PKCS12Test();
        TestResult testResult = pKCS12Test.perform();
        System.out.println(testResult);
    }
}

