/*
 * Decompiled with CFR 0.152.
 */
package by.stub.cli;

import by.stub.annotations.CoberturaIgnore;
import by.stub.utils.JarUtils;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class CommandLineInterpreter {
    public static final List<String> PROVIDED_OPTIONS = Collections.synchronizedList(new LinkedList());
    public static final String OPTION_ADDRESS = "location";
    public static final String OPTION_CLIENTPORT = "stubs";
    public static final String OPTION_TLSPORT = "tls";
    public static final String OPTION_ADMINPORT = "admin";
    public static final String OPTION_CONFIG = "data";
    public static final String OPTION_KEYSTORE = "keystore";
    public static final String OPTION_KEYPASS = "password";
    public static final String OPTION_MUTE = "mute";
    public static final String OPTION_WATCH = "watch";
    public static final String OPTION_HELP = "help";
    public static final String OPTION_VERSION = "version";
    private static final CommandLineParser POSIX_PARSER = new PosixParser();
    private static final Options OPTIONS = new Options();
    private CommandLine line;

    public void parseCommandLine(String[] args) throws ParseException {
        this.line = POSIX_PARSER.parse(OPTIONS, args);
    }

    public boolean isMute() {
        return this.line.hasOption(OPTION_MUTE);
    }

    public boolean isYamlProvided() {
        return this.line.hasOption(OPTION_CONFIG);
    }

    public boolean isHelp() {
        return this.line.hasOption(OPTION_HELP);
    }

    public boolean isVersion() {
        return this.line.hasOption(OPTION_VERSION);
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        String command = String.format("%sjava -jar stubby4j-x.x.xx.jar", "\n");
        formatter.printHelp(command, OPTIONS, true);
    }

    @CoberturaIgnore
    public void printVersion() {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        formatter.printWrapped(pw, 74, JarUtils.readManifestImplementationVersion());
        pw.flush();
    }

    public Map<String, String> getCommandlineParams() {
        final Option[] options = this.line.getOptions();
        return new HashMap<String, String>(){
            {
                for (Option option : options) {
                    this.put(option.getLongOpt(), option.getValue());
                }
                PROVIDED_OPTIONS.addAll(new LinkedList(this.entrySet()));
            }
        };
    }

    static {
        OPTIONS.addOption("l", OPTION_ADDRESS, true, "Hostname at which to bind stubby.");
        OPTIONS.addOption("s", OPTION_CLIENTPORT, true, "Port for stub portal. Defaults to 8882.");
        OPTIONS.addOption("a", OPTION_ADMINPORT, true, "Port for admin portal. Defaults to 8889.");
        OPTIONS.addOption("t", OPTION_TLSPORT, true, "Port for TLS connection. Defaults to 7443.");
        OPTIONS.addOption("d", OPTION_CONFIG, true, "Data file to pre-load endpoints. Valid YAML 1.1 expected.");
        OPTIONS.addOption("k", OPTION_KEYSTORE, true, "Keystore file for custom TLS. By default TLS is enabled using internal keystore.");
        OPTIONS.addOption("p", OPTION_KEYPASS, true, "Password for the provided keystore file.");
        OPTIONS.addOption("h", OPTION_HELP, false, "This help text.");
        OPTIONS.addOption("m", OPTION_MUTE, false, "Prevent stubby from printing to the console.");
        OPTIONS.addOption("v", OPTION_VERSION, false, "Prints out to console stubby version.");
        OptionBuilder.withDescription("Periodically scans for changes in last modification date of the main YAML and referenced external files (if any). The flag can accept an optional arg value which is the watch scan time in milliseconds. If milliseconds is not provided, the watch scans every 100ms. If last modification date changed since the last scan period, the stub configuration is reloaded");
        OptionBuilder.withLongOpt(OPTION_WATCH);
        OptionBuilder.hasOptionalArg();
        Option watch = OptionBuilder.create("w");
        OPTIONS.addOption(watch);
    }
}

