/*
 * Decompiled with CFR 0.152.
 */
package by.stub.database.thread;

import by.stub.cli.ANSITerminal;
import by.stub.database.StubbedDataManager;
import by.stub.yaml.YamlParser;
import java.io.File;
import java.util.Date;
import java.util.Map;

public final class ExternalFilesScanner
implements Runnable {
    private final long sleepTime;
    private final StubbedDataManager stubbedDataManager;

    public ExternalFilesScanner(StubbedDataManager stubbedDataManager, long sleepTime) {
        this.sleepTime = sleepTime;
        this.stubbedDataManager = stubbedDataManager;
        ANSITerminal.status(String.format("External file scan enabled, watching external files referenced from %s", stubbedDataManager.getYamlCanonicalPath()));
    }

    @Override
    public void run() {
        try {
            Map<File, Long> externalFiles = this.stubbedDataManager.getExternalFiles();
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(this.sleepTime);
                boolean isContinue = true;
                String offendingFilename = "";
                for (Map.Entry<File, Long> entry : externalFiles.entrySet()) {
                    long currentFileModified;
                    File file = entry.getKey();
                    long lastModified = entry.getValue();
                    if (lastModified >= (currentFileModified = file.lastModified())) continue;
                    externalFiles.put(file, currentFileModified);
                    isContinue = false;
                    offendingFilename = file.getAbsolutePath();
                    break;
                }
                if (isContinue) continue;
                ANSITerminal.info(String.format("\nExternal file scan detected change in %s\n", offendingFilename));
                try {
                    this.stubbedDataManager.refreshStubbedData(new YamlParser());
                    ANSITerminal.ok(String.format("%sSuccessfully performed live refresh of main YAML with external files from: %s on [" + new Date().toString().trim() + "]%s", "\n", this.stubbedDataManager.getDataYaml(), "\n"));
                }
                catch (Exception ex) {
                    ANSITerminal.error("Could not refresh YAML configuration: " + ex.toString());
                    ANSITerminal.warn(String.format("YAML refresh aborted, previously loaded stubs remain untouched", new Object[0]));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ANSITerminal.error("Could not perform live YAML scan: " + ex.toString());
        }
    }
}

