/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.database.StubbedDataManager;
import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategy;
import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategyFactory;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AdminPortalHandler
extends AbstractHandler {
    public static final String NAME = "admin";
    public static final String ADMIN_ROOT = "/";
    private final StubbedDataManager stubbedDataManager;

    public AdminPortalHandler(StubbedDataManager stubbedDataManager) {
        this.stubbedDataManager = stubbedDataManager;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        baseRequest.setHandled(true);
        HttpServletResponseWithGetStatus wrapper = new HttpServletResponseWithGetStatus(response);
        wrapper.setContentType("text/html;charset=UTF-8");
        wrapper.setStatus(200);
        wrapper.setHeader("Server", HandlerUtils.constructHeaderServerName());
        wrapper.setHeader("Date", new Date().toString());
        wrapper.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        wrapper.setHeader("Pragma", "no-cache");
        wrapper.setDateHeader("Expires", 0L);
        AdminResponseHandlingStrategy strategyStubResponse = AdminResponseHandlingStrategyFactory.getStrategy(request);
        try {
            strategyStubResponse.handle(request, wrapper, this.stubbedDataManager);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, "Problem handling request in Admin handler: " + ex.toString());
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), wrapper);
    }
}

