/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.database.StubbedDataManager;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AjaxEndpointStatsHandler
extends AbstractHandler {
    private static final String POPUP_STATS_HTML_TEMPLATE = HandlerUtils.getHtmlResourceByName("_popup_stats");
    private final StubbedDataManager stubbedDataManager;

    public AjaxEndpointStatsHandler(StubbedDataManager stubbedDataManager) {
        this.stubbedDataManager = stubbedDataManager;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        baseRequest.setHandled(true);
        HttpServletResponseWithGetStatus wrapper = new HttpServletResponseWithGetStatus(response);
        HandlerUtils.setResponseMainHeaders(wrapper);
        wrapper.setContentType("text/plain;charset=UTF-8");
        wrapper.setStatus(200);
        try {
            if (request.getRequestURI().contains("stats/check")) {
                wrapper.getWriter().println(!this.stubbedDataManager.getResourceStats().isEmpty());
            } else {
                ConsoleUtils.logIncomingRequest(request);
                String htmlPopup = String.format(POPUP_STATS_HTML_TEMPLATE, this.stubbedDataManager.getResourceStatsAsCsv());
                wrapper.getWriter().println(htmlPopup);
                ConsoleUtils.logOutgoingResponse(request.getRequestURI(), wrapper);
            }
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(wrapper, 500, ex.toString());
        }
    }
}

