/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.annotations.VisibleForTesting;
import by.stub.database.StubbedDataManager;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import by.stub.utils.ObjectUtils;
import by.stub.yaml.stubs.StubHttpLifecycle;
import by.stub.yaml.stubs.StubTypes;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AjaxResourceContentHandler
extends AbstractHandler {
    private static final Pattern REGEX_REQUEST = Pattern.compile("^(request)$");
    private static final Pattern REGEX_RESPONSE = Pattern.compile("^(response)$");
    private static final Pattern REGEX_HTTPLIFECYCLE = Pattern.compile("^(httplifecycle)$");
    private static final Pattern REGEX_NUMERIC = Pattern.compile("^[0-9]+$");
    private static final String POPUP_HTML_TEMPLATE = HandlerUtils.getHtmlResourceByName("_popup_generic");
    private final StubbedDataManager stubbedDataManager;

    public AjaxResourceContentHandler(StubbedDataManager stubbedDataManager) {
        this.stubbedDataManager = stubbedDataManager;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        baseRequest.setHandled(true);
        HttpServletResponseWithGetStatus wrapper = new HttpServletResponseWithGetStatus(response);
        HandlerUtils.setResponseMainHeaders(wrapper);
        wrapper.setContentType("text/plain;charset=UTF-8");
        wrapper.setStatus(200);
        String[] uriFragments = request.getRequestURI().split("/");
        int urlFragmentsLength = uriFragments.length;
        String targetFieldName = uriFragments[urlFragmentsLength - 1];
        String stubType = uriFragments[urlFragmentsLength - 2];
        if (REGEX_NUMERIC.matcher(stubType).matches()) {
            int sequencedResponseId = Integer.parseInt(stubType);
            int stubHttpCycleIndex = Integer.parseInt(uriFragments[urlFragmentsLength - 4]);
            StubHttpLifecycle foundStubHttpLifecycle = this.throwErrorOnNonexistentResourceIndex(wrapper, stubHttpCycleIndex);
            this.renderAjaxResponseContent(wrapper, sequencedResponseId, targetFieldName, foundStubHttpLifecycle);
        } else {
            int stubHttpCycleIndex = Integer.parseInt(uriFragments[urlFragmentsLength - 3]);
            StubHttpLifecycle foundStubHttpLifecycle = this.throwErrorOnNonexistentResourceIndex(wrapper, stubHttpCycleIndex);
            if (REGEX_REQUEST.matcher(stubType).matches()) {
                this.renderAjaxResponseContent(wrapper, StubTypes.REQUEST, targetFieldName, foundStubHttpLifecycle);
            } else if (REGEX_RESPONSE.matcher(stubType).matches()) {
                this.renderAjaxResponseContent(wrapper, StubTypes.RESPONSE, targetFieldName, foundStubHttpLifecycle);
            } else if (REGEX_HTTPLIFECYCLE.matcher(stubType).matches()) {
                this.renderAjaxResponseContent(wrapper, StubTypes.HTTPLIFECYCLE, targetFieldName, foundStubHttpLifecycle);
            } else {
                wrapper.getWriter().println(String.format("Could not fetch the content for stub type: %s", stubType));
            }
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), wrapper);
    }

    @VisibleForTesting
    void renderAjaxResponseContent(HttpServletResponseWithGetStatus wrapper, StubTypes stubType, String targetFieldName, StubHttpLifecycle foundStubHttpLifecycle) throws IOException {
        try {
            String ajaxResponse = foundStubHttpLifecycle.getAjaxResponseContent(stubType, targetFieldName);
            String htmlPopup = String.format(POPUP_HTML_TEMPLATE, foundStubHttpLifecycle.getResourceId(), targetFieldName, ajaxResponse);
            wrapper.getWriter().println(htmlPopup);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(wrapper, 500, ex.toString());
        }
    }

    @VisibleForTesting
    void renderAjaxResponseContent(HttpServletResponseWithGetStatus wrapper, int sequencedResponseId, String targetFieldName, StubHttpLifecycle foundStubHttpLifecycle) throws IOException {
        try {
            String ajaxResponse = foundStubHttpLifecycle.getAjaxResponseContent(targetFieldName, sequencedResponseId);
            String htmlPopup = String.format(POPUP_HTML_TEMPLATE, foundStubHttpLifecycle.getResourceId(), targetFieldName, ajaxResponse);
            wrapper.getWriter().println(htmlPopup);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(wrapper, 500, ex.toString());
        }
    }

    @VisibleForTesting
    StubHttpLifecycle throwErrorOnNonexistentResourceIndex(HttpServletResponseWithGetStatus wrapper, int stubHttpCycleIndex) throws IOException {
        StubHttpLifecycle foundStubHttpLifecycle = this.stubbedDataManager.getMatchedStubHttpLifecycle(stubHttpCycleIndex);
        if (ObjectUtils.isNull(foundStubHttpLifecycle)) {
            wrapper.getWriter().println("Resource does not exist for ID: " + stubHttpCycleIndex);
        }
        return foundStubHttpLifecycle;
    }
}

