/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.database.StubbedDataManager;
import by.stub.handlers.strategy.stubs.StubResponseHandlingStrategy;
import by.stub.handlers.strategy.stubs.StubsResponseHandlingStrategyFactory;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class StubsPortalHandler
extends AbstractHandler {
    private final StubbedDataManager stubbedDataManager;

    public StubsPortalHandler(StubbedDataManager stubbedDataManager) {
        this.stubbedDataManager = stubbedDataManager;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        baseRequest.setHandled(true);
        StubRequest assertionStubRequest = StubRequest.createFromHttpServletRequest(request);
        StubResponse foundStubResponse = this.stubbedDataManager.findStubResponseFor(assertionStubRequest);
        StubResponseHandlingStrategy strategyStubResponse = StubsResponseHandlingStrategyFactory.getStrategy(foundStubResponse);
        HttpServletResponseWithGetStatus wrapper = new HttpServletResponseWithGetStatus(response);
        try {
            strategyStubResponse.handle(wrapper, assertionStubRequest);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
        ConsoleUtils.logOutgoingResponse(assertionStubRequest.getUrl(), wrapper);
    }
}

