/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy.admin;

import by.stub.database.StubbedDataManager;
import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategy;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.YamlParser;
import javax.servlet.http.HttpServletRequest;

public class PostHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponseWithGetStatus wrapper, StubbedDataManager stubbedDataManager) throws Exception {
        if (!request.getRequestURI().equals("/")) {
            wrapper.setStatus(405);
            wrapper.getWriter().println("Method POST is not allowed on URI " + request.getRequestURI());
            return;
        }
        String post = HandlerUtils.extractPostRequestBody(request, "admin");
        if (!StringUtils.isSet(post)) {
            String errorMessage = String.format("%s request on URI %s was empty", request.getMethod(), request.getRequestURI());
            HandlerUtils.configureErrorResponse(wrapper, 204, errorMessage);
            return;
        }
        stubbedDataManager.refreshStubbedData(new YamlParser(), post);
        if (stubbedDataManager.getStubHttpLifecycles().size() == 1) {
            wrapper.addHeader("Location", stubbedDataManager.getOnlyStubRequestUrl());
        }
        wrapper.setStatus(201);
        wrapper.getWriter().println("Configuration created successfully");
    }
}

