/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy.admin;

import by.stub.database.StubbedDataManager;
import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategy;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.YamlParser;
import javax.servlet.http.HttpServletRequest;

public class PutHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponseWithGetStatus wrapper, StubbedDataManager stubbedDataManager) throws Exception {
        if (request.getRequestURI().equals("/")) {
            wrapper.setStatus(405);
            wrapper.getWriter().println("Method PUT is not allowed on URI " + request.getRequestURI());
            return;
        }
        int contextPathLength = "/".length();
        String pathInfoNoHeadingSlash = request.getRequestURI().substring(contextPathLength);
        int stubIndexToUpdate = Integer.parseInt(pathInfoNoHeadingSlash);
        if (!stubbedDataManager.isStubHttpLifecycleExistsByIndex(stubIndexToUpdate)) {
            String errorMessage = String.format("Stub request index#%s does not exist, cannot update", stubIndexToUpdate);
            HandlerUtils.configureErrorResponse(wrapper, 204, errorMessage);
            return;
        }
        String put = HandlerUtils.extractPostRequestBody(request, "admin");
        if (!StringUtils.isSet(put)) {
            String errorMessage = String.format("%s request on URI %s was empty", request.getMethod(), request.getRequestURI());
            HandlerUtils.configureErrorResponse(wrapper, 204, errorMessage);
            return;
        }
        String updatedCycleUrl = stubbedDataManager.refreshStubbedData(new YamlParser(), put, stubIndexToUpdate);
        wrapper.setStatus(201);
        wrapper.addHeader("Location", updatedCycleUrl);
        String successfulMessage = String.format("Stub request index#%s updated successfully", stubIndexToUpdate);
        wrapper.getWriter().println(successfulMessage);
    }
}

