/*
 * Decompiled with CFR 0.152.
 */
package by.stub.utils;

import by.stub.annotations.CoberturaIgnore;
import by.stub.repackaged.org.apache.commons.io.IOUtils;
import by.stub.utils.ObjectUtils;
import by.stub.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FileUtils {
    public static final Set<String> ASCII_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".ajx", ".am", ".asa", ".asc", ".asp", ".aspx", ".awk", ".bat", ".c", ".cdf", ".cf", ".cfg", ".cfm", ".cgi", ".cnf", ".conf", ".cpp", ".css", ".csv", ".ctl", ".dat", ".dhtml", ".diz", ".file", ".forward", ".grp", ".h", ".hpp", ".hqx", ".hta", ".htaccess", ".htc", ".htm", ".html", ".htpasswd", ".htt", ".htx", ".in", ".inc", ".info", ".ini", ".ink", ".java", ".js", ".json", ".jsp", ".log", ".logfile", ".m3u", ".m4", ".m4a", ".mak", ".map", ".model", ".msg", ".nfo", ".nsi", ".info", ".old", ".pas", ".patch", ".perl", ".php", ".php2", ".php3", ".php4", ".php5", ".php6", ".phtml", ".pix", ".pl", ".pm", ".po", ".pwd", ".py", ".qmail", ".rb", ".rbl", ".rbw", ".readme", ".reg", ".rss", ".rtf", ".ruby", ".session", ".setup", ".sh", ".shtm", ".shtml", ".sql", ".ssh", ".stm", ".style", ".svg", ".tcl", ".text", ".threads", ".tmpl", ".tpl", ".txt", ".ubb", ".vbs", ".xhtml", ".xml", ".xrc", ".xsl", ".yaml", ".yml")));
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_MAC_OS_PRE_X = "\r";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR_TOKEN = "[_T_O_K_E_N_]";
    public static final String LINE_SEPARATOR;

    private FileUtils() {
    }

    public static File uriToFile(String dataYamlConfigParentDir, String relativePath) throws IOException {
        File contentFile = new File(dataYamlConfigParentDir, relativePath);
        if (!contentFile.isFile()) {
            throw new IOException(String.format("Could not load file from path: %s", relativePath));
        }
        return contentFile;
    }

    public static File uriToFile(String absolutePath) throws IOException {
        File contentFile = new File(absolutePath);
        if (!contentFile.isFile()) {
            throw new IOException(String.format("Could not load file from path: %s", absolutePath));
        }
        return contentFile;
    }

    @CoberturaIgnore
    public static File fileFromString(String content) {
        try {
            File temp = File.createTempFile("tmp", ".tmp");
            temp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(content);
            out.close();
            return temp;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String asciiFileToString(File file) throws IOException {
        String loadedContent = StringUtils.inputStreamToString(new BufferedInputStream(new FileInputStream(file)));
        return FileUtils.enforceSystemLineSeparator(loadedContent);
    }

    public static byte[] asciiFileToUtf8Bytes(File file) throws IOException {
        String loadedContent = FileUtils.asciiFileToString(file);
        return loadedContent.getBytes(StringUtils.charsetUTF8());
    }

    public static boolean isAsciiFile(File file) throws IOException {
        return ASCII_TYPES.contains(StringUtils.extractFilenameExtension(file.getName()));
    }

    public static boolean isTemplateFile(File file) throws IOException {
        if (FileUtils.isAsciiFile(file)) {
            return FileUtils.asciiFileToString(file).contains("<%");
        }
        return false;
    }

    public static byte[] fileToBytes(File file) throws IOException {
        if (FileUtils.isAsciiFile(file)) {
            return FileUtils.asciiFileToUtf8Bytes(file);
        }
        return FileUtils.binaryFileToBytes(file);
    }

    @CoberturaIgnore
    public static byte[] binaryFileToBytes(String dataYamlConfigParentDir, String relativePath) throws IOException {
        File contentFile = new File(dataYamlConfigParentDir, relativePath);
        if (!contentFile.isFile()) {
            throw new IOException(String.format("Could not load file from path: %s", relativePath));
        }
        return IOUtils.toByteArray(new BufferedInputStream(new FileInputStream(contentFile)));
    }

    public static byte[] binaryFileToBytes(File file) throws IOException {
        return IOUtils.toByteArray(new BufferedInputStream(new FileInputStream(file)));
    }

    public static String enforceSystemLineSeparator(String loadedContent) {
        if (!StringUtils.isSet(loadedContent)) {
            return "";
        }
        return loadedContent.replace(LINE_SEPARATOR_WINDOWS, LINE_SEPARATOR_TOKEN).replace(LINE_SEPARATOR_MAC_OS_PRE_X, LINE_SEPARATOR_TOKEN).replace(LINE_SEPARATOR_UNIX, LINE_SEPARATOR_TOKEN).replace(LINE_SEPARATOR_TOKEN, LINE_SEPARATOR);
    }

    public static BufferedReader constructReader(String content) {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(StringUtils.charsetUTF8()));
        InputStreamReader reader = new InputStreamReader((InputStream)is, StringUtils.charsetUTF8());
        return new BufferedReader(reader);
    }

    public static BufferedReader constructReader(File file) throws FileNotFoundException {
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), StringUtils.charsetUTF8());
        return new BufferedReader(reader);
    }

    static {
        int initialSize = 4;
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(4);
        PrintWriter out = new PrintWriter(stringBuilderWriter);
        out.println();
        LINE_SEPARATOR = stringBuilderWriter.toString();
        out.close();
    }

    private static final class StringBuilderWriter
    extends Writer
    implements Serializable {
        private final StringBuilder builder;

        private StringBuilderWriter(int capacity) {
            this.builder = new StringBuilder(capacity);
        }

        @Override
        public void write(char[] value, int offset, int length) {
            if (ObjectUtils.isNotNull(value)) {
                this.builder.append(value, offset, length);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

