/*
 * Decompiled with CFR 0.152.
 */
package by.stub.utils;

import by.stub.annotations.CoberturaIgnore;
import by.stub.exception.Stubby4JException;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.ObjectUtils;
import by.stub.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static void configureErrorResponse(HttpServletResponse response, int httpStatus, String message) throws IOException {
        response.setStatus(httpStatus);
        response.sendError(httpStatus, message);
        response.flushBuffer();
    }

    public static String getHtmlResourceByName(String templateSuffix) {
        String htmlTemplatePath = String.format("/ui/html/%s.html", templateSuffix);
        InputStream inputStream = HandlerUtils.class.getResourceAsStream(htmlTemplatePath);
        if (ObjectUtils.isNull(inputStream)) {
            throw new Stubby4JException(String.format("Could not find resource %s", htmlTemplatePath));
        }
        return StringUtils.inputStreamToString(inputStream);
    }

    @CoberturaIgnore
    public static String constructHeaderServerName() {
        Package pkg = HandlerUtils.class.getPackage();
        String implementationVersion = StringUtils.isSet(pkg.getImplementationVersion()) ? pkg.getImplementationVersion() : "x.x.xx";
        return String.format("stubby4j/%s (HTTP stub server)", implementationVersion);
    }

    public static void setResponseMainHeaders(HttpServletResponse response) {
        response.setHeader("Server", HandlerUtils.constructHeaderServerName());
        response.setHeader("Date", new Date().toString());
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static String linkifyRequestUrl(String scheme, Object uri, String host, int port) {
        String fullUrl = String.format("%s://%s:%s%s", scheme, host, port, uri);
        String href = StringUtils.encodeSingleQuotes(fullUrl);
        return String.format("<a target='_blank' href='%s'>%s</a>", href, fullUrl);
    }

    public static String populateHtmlTemplate(String templateName, Object ... params) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(HandlerUtils.getHtmlResourceByName(templateName), params));
        return builder.toString();
    }

    public static String extractPostRequestBody(HttpServletRequest request, String source) throws IOException {
        HashSet<String> httpMethodsContainingBody = new HashSet<String>(){
            {
                this.add("post");
                this.add("put");
            }
        };
        if (!httpMethodsContainingBody.contains(request.getMethod().toLowerCase())) {
            return null;
        }
        try {
            return StringUtils.inputStreamToString(request.getInputStream());
        }
        catch (Exception ex) {
            String err = String.format("Error when extracting POST body: %s, returning null..", ex.toString());
            ConsoleUtils.logIncomingRequestError(request, source, err);
            return null;
        }
    }

    public static String calculateStubbyUpTime(long timestamp) {
        long days = TimeUnit.MILLISECONDS.toDays(timestamp);
        long hours = TimeUnit.MILLISECONDS.toHours(timestamp) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(timestamp));
        long mins = TimeUnit.MILLISECONDS.toMinutes(timestamp) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(timestamp));
        long secs = TimeUnit.MILLISECONDS.toSeconds(timestamp) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(timestamp));
        return String.format("%d day%s, %d hour%s, %d min%s, %d sec%s", days, HandlerUtils.pluralize(days), hours, HandlerUtils.pluralize(hours), mins, HandlerUtils.pluralize(mins), secs, HandlerUtils.pluralize(secs));
    }

    private static String pluralize(long timeUnit) {
        return timeUnit == 1L ? "" : "s";
    }
}

