/*
 * Decompiled with CFR 0.152.
 */
package by.stub.yaml.stubs;

import by.stub.utils.ReflectionUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import by.stub.yaml.stubs.StubTypes;
import java.util.LinkedList;
import java.util.List;

public class StubHttpLifecycle {
    public static final StubHttpLifecycle NULL = null;
    private String httpLifeCycleAsYaml;
    private StubRequest request;
    private Object response = StubResponse.newStubResponse();
    private int responseSequenceCounter = 0;
    private String requestAsYaml;
    private String responseAsYaml;

    public void setRequest(StubRequest request) {
        this.request = request;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public StubRequest getRequest() {
        return this.request;
    }

    public StubResponse getResponse() {
        return this.getActualStubbedResponse();
    }

    public List<StubResponse> getAllResponses() {
        if (this.response instanceof StubResponse) {
            return new LinkedList<StubResponse>(){
                {
                    this.add((StubResponse)StubHttpLifecycle.this.response);
                }
            };
        }
        return (LinkedList)this.response;
    }

    public boolean isRestricted() {
        return StringUtils.isSet(this.getAuthorizationHeader());
    }

    public boolean hasNotAuthorized(StubHttpLifecycle assertingLifecycle) {
        String assertingAuthorization;
        String stubbedAuthorization = this.getAuthorizationHeader();
        return !stubbedAuthorization.equals(assertingAuthorization = assertingLifecycle.getAuthorizationHeader());
    }

    private String getAuthorizationHeader() {
        return this.request.getHeaders().get("authorization");
    }

    public String getResourceId() {
        return this.getAllResponses().get(0).getHeaders().get("x-stubby-resource-id");
    }

    public StubResponse getActualStubbedResponse() {
        if (this.response instanceof StubResponse) {
            return (StubResponse)this.response;
        }
        LinkedList responses = (LinkedList)this.response;
        if (responses.isEmpty()) {
            return StubResponse.newStubResponse();
        }
        StubResponse sequenceStubResponse = (StubResponse)responses.get(this.responseSequenceCounter);
        this.responseSequenceCounter = this.responseSequenceCounter + 1 == responses.size() ? (this.responseSequenceCounter = 0) : (this.responseSequenceCounter = this.responseSequenceCounter + 1);
        return sequenceStubResponse;
    }

    public String getHttpLifeCycleAsYaml() {
        return this.httpLifeCycleAsYaml;
    }

    public void setHttpLifeCycleAsYaml(String httpLifeCycleAsYaml) {
        this.httpLifeCycleAsYaml = httpLifeCycleAsYaml;
    }

    public String getRequestAsYaml() {
        return this.requestAsYaml;
    }

    public void setRequestAsYaml(String requestAsYaml) {
        this.requestAsYaml = requestAsYaml;
    }

    public String getResponseAsYaml() {
        return this.responseAsYaml;
    }

    public void setResponseAsYaml(String responseAsYaml) {
        this.responseAsYaml = responseAsYaml;
    }

    public void setResourceId(int listIndex) {
        for (StubResponse response : this.getAllResponses()) {
            response.addResourceIDHeader(listIndex);
        }
    }

    public String getAjaxResponseContent(StubTypes stubType, String propertyName) throws Exception {
        switch (stubType) {
            case REQUEST: {
                return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this.request, propertyName));
            }
            case RESPONSE: {
                return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this.getResponse(), propertyName));
            }
        }
        return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this, propertyName));
    }

    public String getAjaxResponseContent(String propertyName, int sequencedResponseId) throws Exception {
        List<StubResponse> allResponses = this.getAllResponses();
        StubResponse sequencedResponse = allResponses.get(sequencedResponseId);
        return StringUtils.objectToString(ReflectionUtils.getPropertyValue(sequencedResponse, propertyName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StubHttpLifecycle)) {
            return false;
        }
        StubHttpLifecycle that = (StubHttpLifecycle)o;
        return this.request.equals(that.request);
    }
}

