/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v21.group.ADT_AXX_PATIENT;
import ca.uhn.hl7v2.model.v21.segment.DG1;
import ca.uhn.hl7v2.model.v21.segment.EVN;
import ca.uhn.hl7v2.model.v21.segment.MRG;
import ca.uhn.hl7v2.model.v21.segment.MSH;
import ca.uhn.hl7v2.model.v21.segment.NK1;
import ca.uhn.hl7v2.model.v21.segment.NPU;
import ca.uhn.hl7v2.model.v21.segment.PD1;
import ca.uhn.hl7v2.model.v21.segment.PID;
import ca.uhn.hl7v2.model.v21.segment.PV1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_AXX
extends AbstractMessage {
    public ADT_AXX() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_AXX(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, false, false);
            this.add(MRG.class, false, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, false);
            this.add(PV1.class, false, false);
            this.add(DG1.class, false, false);
            this.add(ADT_AXX_PATIENT.class, false, true);
            this.add(NPU.class, false, false);
            this.add(PID.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_AXX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public MRG getMRG() {
        return (MRG)this.getTyped("MRG", MRG.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public DG1 getDG1() {
        return (DG1)this.getTyped("DG1", DG1.class);
    }

    public ADT_AXX_PATIENT getPATIENT() {
        return (ADT_AXX_PATIENT)this.getTyped("PATIENT", ADT_AXX_PATIENT.class);
    }

    public ADT_AXX_PATIENT getPATIENT(int rep) {
        return (ADT_AXX_PATIENT)this.getTyped("PATIENT", rep, ADT_AXX_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<ADT_AXX_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", ADT_AXX_PATIENT.class);
    }

    public void insertPATIENT(ADT_AXX_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public ADT_AXX_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (ADT_AXX_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public ADT_AXX_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (ADT_AXX_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public NPU getNPU() {
        return (NPU)this.getTyped("NPU", NPU.class);
    }

    public PID getPID2() {
        return (PID)this.getTyped("PID2", PID.class);
    }
}

