/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CM_CCP;
import ca.uhn.hl7v2.model.v23.datatype.CM_CD_ELECTRODE;
import ca.uhn.hl7v2.model.v23.datatype.CM_CSU;
import ca.uhn.hl7v2.model.v23.datatype.CM_MDV;
import ca.uhn.hl7v2.model.v23.datatype.CM_WVI;
import ca.uhn.hl7v2.model.v23.datatype.NM;

public class CD
extends AbstractComposite {
    private Type[] data;

    public CD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[6];
        this.data[0] = new CM_WVI(this.getMessage());
        this.data[1] = new CM_CD_ELECTRODE(this.getMessage());
        this.data[2] = new CM_CSU(this.getMessage());
        this.data[3] = new CM_CCP(this.getMessage());
        this.data[4] = new NM(this.getMessage());
        this.data[5] = new CM_MDV(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CM_WVI getChannelIdentifier() {
        return (CM_WVI)this.getTyped(0, CM_WVI.class);
    }

    public CM_WVI getCd1_ChannelIdentifier() {
        return (CM_WVI)this.getTyped(0, CM_WVI.class);
    }

    public CM_CD_ELECTRODE getElectrodeNames() {
        return (CM_CD_ELECTRODE)this.getTyped(1, CM_CD_ELECTRODE.class);
    }

    public CM_CD_ELECTRODE getCd2_ElectrodeNames() {
        return (CM_CD_ELECTRODE)this.getTyped(1, CM_CD_ELECTRODE.class);
    }

    public CM_CSU getChannelSensitivityUnits() {
        return (CM_CSU)this.getTyped(2, CM_CSU.class);
    }

    public CM_CSU getCd3_ChannelSensitivityUnits() {
        return (CM_CSU)this.getTyped(2, CM_CSU.class);
    }

    public CM_CCP getCalibrationParameters() {
        return (CM_CCP)this.getTyped(3, CM_CCP.class);
    }

    public CM_CCP getCd4_CalibrationParameters() {
        return (CM_CCP)this.getTyped(3, CM_CCP.class);
    }

    public NM getSamplingFrequency() {
        return (NM)this.getTyped(4, NM.class);
    }

    public NM getCd5_SamplingFrequency() {
        return (NM)this.getTyped(4, NM.class);
    }

    public CM_MDV getMinimumMaximumDataValues() {
        return (CM_MDV)this.getTyped(5, CM_MDV.class);
    }

    public CM_MDV getCd6_MinimumMaximumDataValues() {
        return (CM_MDV)this.getTyped(5, CM_MDV.class);
    }
}

