/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBX
extends AbstractSegment {
    public OBX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - OBX");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(125)}, "Value Type");
            this.add(CE.class, true, 1, 590, new Object[]{this.getMessage()}, "Observation Identifier");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Observation Sub-ID");
            this.add(Varies.class, false, 0, 65536, new Object[]{this.getMessage()}, "Observation Value");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Units");
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "References Range");
            this.add(ID.class, false, 5, 5, new Object[]{this.getMessage(), new Integer(78)}, "Abnormal Flags");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Probability");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(80)}, "Nature of Abnormal Test");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(85)}, "Observ Result Status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date Last Obs Normal Values");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "User Defined Access Checks");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of the Observation");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Producer's ID");
            this.add(XCN.class, false, 1, 80, new Object[]{this.getMessage()}, "Responsible Observer");
            this.add(CE.class, false, 0, 80, new Object[]{this.getMessage()}, "Observation Method");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OBX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDOBX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObx1_SetIDOBX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getValueType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getObx2_ValueType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getObservationIdentifier() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getObx3_ObservationIdentifier() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getObservationSubID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getObx4_ObservationSubID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public Varies[] getObservationValue() {
        Varies[] retVal = (Varies[])this.getTypedField(5, (Type[])new Varies[0]);
        return retVal;
    }

    public Varies[] getObx5_ObservationValue() {
        Varies[] retVal = (Varies[])this.getTypedField(5, (Type[])new Varies[0]);
        return retVal;
    }

    public int getObservationValueReps() {
        return this.getReps(5);
    }

    public Varies getObservationValue(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public Varies getObx5_ObservationValue(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public int getObx5_ObservationValueReps() {
        return this.getReps(5);
    }

    public Varies insertObservationValue(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies insertObx5_ObservationValue(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies removeObservationValue(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public Varies removeObx5_ObservationValue(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public CE getUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getObx6_Units() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getReferencesRange() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getObx7_ReferencesRange() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ID[] getAbnormalFlags() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getObx8_AbnormalFlags() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public int getAbnormalFlagsReps() {
        return this.getReps(8);
    }

    public ID getAbnormalFlags(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public ID getObx8_AbnormalFlags(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public int getObx8_AbnormalFlagsReps() {
        return this.getReps(8);
    }

    public ID insertAbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertObx8_AbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeAbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removeObx8_AbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public NM getProbability() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getObx9_Probability() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getNatureOfAbnormalTest() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getObx10_NatureOfAbnormalTest() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getObservResultStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObx11_ObservResultStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getDateLastObsNormalValues() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getObx12_DateLastObsNormalValues() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getUserDefinedAccessChecks() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObx13_UserDefinedAccessChecks() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getDateTimeOfTheObservation() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getObx14_DateTimeOfTheObservation() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getProducerSID() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getObx15_ProducerSID() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN getResponsibleObserver() {
        XCN retVal = (XCN)this.getTypedField(16, 0);
        return retVal;
    }

    public XCN getObx16_ResponsibleObserver() {
        XCN retVal = (XCN)this.getTypedField(16, 0);
        return retVal;
    }

    public CE[] getObservationMethod() {
        CE[] retVal = (CE[])this.getTypedField(17, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObx17_ObservationMethod() {
        CE[] retVal = (CE[])this.getTypedField(17, (Type[])new CE[0]);
        return retVal;
    }

    public int getObservationMethodReps() {
        return this.getReps(17);
    }

    public CE getObservationMethod(int rep) {
        CE retVal = (CE)this.getTypedField(17, rep);
        return retVal;
    }

    public CE getObx17_ObservationMethod(int rep) {
        CE retVal = (CE)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObx17_ObservationMethodReps() {
        return this.getReps(17);
    }

    public CE insertObservationMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE insertObx17_ObservationMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE removeObservationMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public CE removeObx17_ObservationMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new Varies(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(78));
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(80));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(85));
            }
            case 11: {
                return new TS(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

