/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.PLN;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CTD
extends AbstractSegment {
    public CTD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 0, 250, new Object[]{this.getMessage()}, "Contact Role");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact Address");
            this.add(PL.class, false, 1, 60, new Object[]{this.getMessage()}, "Contact Location");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact Communication Information");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Preferred Method of Contact");
            this.add(PLN.class, false, 0, 100, new Object[]{this.getMessage()}, "Contact Identifiers");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CTD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE[] getContactRole() {
        CE[] retVal = (CE[])this.getTypedField(1, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getCtd1_ContactRole() {
        CE[] retVal = (CE[])this.getTypedField(1, (Type[])new CE[0]);
        return retVal;
    }

    public int getContactRoleReps() {
        return this.getReps(1);
    }

    public CE getContactRole(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public CE getCtd1_ContactRole(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getCtd1_ContactRoleReps() {
        return this.getReps(1);
    }

    public CE insertContactRole(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE insertCtd1_ContactRole(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE removeContactRole(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE removeCtd1_ContactRole(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public XPN[] getContactName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getCtd2_ContactName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, (Type[])new XPN[0]);
        return retVal;
    }

    public int getContactNameReps() {
        return this.getReps(2);
    }

    public XPN getContactName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public XPN getCtd2_ContactName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public int getCtd2_ContactNameReps() {
        return this.getReps(2);
    }

    public XPN insertContactName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN insertCtd2_ContactName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN removeContactName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XPN removeCtd2_ContactName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XAD[] getContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getCtd3_ContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, (Type[])new XAD[0]);
        return retVal;
    }

    public int getContactAddressReps() {
        return this.getReps(3);
    }

    public XAD getContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public XAD getCtd3_ContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public int getCtd3_ContactAddressReps() {
        return this.getReps(3);
    }

    public XAD insertContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD insertCtd3_ContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD removeContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XAD removeCtd3_ContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public PL getContactLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public PL getCtd4_ContactLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public XTN[] getContactCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getCtd5_ContactCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, (Type[])new XTN[0]);
        return retVal;
    }

    public int getContactCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN getContactCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public XTN getCtd5_ContactCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getCtd5_ContactCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN insertContactCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN insertCtd5_ContactCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN removeContactCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN removeCtd5_ContactCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public CE getPreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getCtd6_PreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public PLN[] getContactIdentifiers() {
        PLN[] retVal = (PLN[])this.getTypedField(7, (Type[])new PLN[0]);
        return retVal;
    }

    public PLN[] getCtd7_ContactIdentifiers() {
        PLN[] retVal = (PLN[])this.getTypedField(7, (Type[])new PLN[0]);
        return retVal;
    }

    public int getContactIdentifiersReps() {
        return this.getReps(7);
    }

    public PLN getContactIdentifiers(int rep) {
        PLN retVal = (PLN)this.getTypedField(7, rep);
        return retVal;
    }

    public PLN getCtd7_ContactIdentifiers(int rep) {
        PLN retVal = (PLN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getCtd7_ContactIdentifiersReps() {
        return this.getReps(7);
    }

    public PLN insertContactIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(7, rep);
    }

    public PLN insertCtd7_ContactIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(7, rep);
    }

    public PLN removeContactIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(7, rep);
    }

    public PLN removeCtd7_ContactIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(7, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new XPN(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new PL(this.getMessage());
            }
            case 4: {
                return new XTN(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new PLN(this.getMessage());
            }
        }
        return null;
    }
}

