/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.DT;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.SI;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.XAD;
import ca.uhn.hl7v2.model.v251.datatype.XCN;
import ca.uhn.hl7v2.model.v251.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CM0
extends AbstractSegment {
    public CM0(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - CM0");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Sponsor Study ID");
            this.add(EI.class, false, 3, 60, new Object[]{this.getMessage()}, "Alternate Study ID");
            this.add(ST.class, true, 1, 300, new Object[]{this.getMessage()}, "Title of Study");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Chairman of Study");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Last IRB Approval Date");
            this.add(NM.class, false, 1, 8, new Object[]{this.getMessage()}, "Total Accrual to Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Last Accrual Date");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact for Study");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage()}, "Contact's Telephone Number");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Contact's Address");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CM0 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDCM0() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getCm01_SetIDCM0() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSponsorStudyID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getCm02_SponsorStudyID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI[] getAlternateStudyID() {
        EI[] retVal = (EI[])this.getTypedField(3, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getCm03_AlternateStudyID() {
        EI[] retVal = (EI[])this.getTypedField(3, (Type[])new EI[0]);
        return retVal;
    }

    public int getAlternateStudyIDReps() {
        return this.getReps(3);
    }

    public EI getAlternateStudyID(int rep) {
        EI retVal = (EI)this.getTypedField(3, rep);
        return retVal;
    }

    public EI getCm03_AlternateStudyID(int rep) {
        EI retVal = (EI)this.getTypedField(3, rep);
        return retVal;
    }

    public int getCm03_AlternateStudyIDReps() {
        return this.getReps(3);
    }

    public EI insertAlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(3, rep);
    }

    public EI insertCm03_AlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(3, rep);
    }

    public EI removeAlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(3, rep);
    }

    public EI removeCm03_AlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(3, rep);
    }

    public ST getTitleOfStudy() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getCm04_TitleOfStudy() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN[] getChairmanOfStudy() {
        XCN[] retVal = (XCN[])this.getTypedField(5, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getCm05_ChairmanOfStudy() {
        XCN[] retVal = (XCN[])this.getTypedField(5, (Type[])new XCN[0]);
        return retVal;
    }

    public int getChairmanOfStudyReps() {
        return this.getReps(5);
    }

    public XCN getChairmanOfStudy(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public XCN getCm05_ChairmanOfStudy(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getCm05_ChairmanOfStudyReps() {
        return this.getReps(5);
    }

    public XCN insertChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertCm05_ChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removeChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removeCm05_ChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public DT getLastIRBApprovalDate() {
        DT retVal = (DT)this.getTypedField(6, 0);
        return retVal;
    }

    public DT getCm06_LastIRBApprovalDate() {
        DT retVal = (DT)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getTotalAccrualToDate() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getCm07_TotalAccrualToDate() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getLastAccrualDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getCm08_LastAccrualDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public XCN[] getContactForStudy() {
        XCN[] retVal = (XCN[])this.getTypedField(9, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getCm09_ContactForStudy() {
        XCN[] retVal = (XCN[])this.getTypedField(9, (Type[])new XCN[0]);
        return retVal;
    }

    public int getContactForStudyReps() {
        return this.getReps(9);
    }

    public XCN getContactForStudy(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public XCN getCm09_ContactForStudy(int rep) {
        XCN retVal = (XCN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getCm09_ContactForStudyReps() {
        return this.getReps(9);
    }

    public XCN insertContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertCm09_ContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removeCm09_ContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XTN getContactSTelephoneNumber() {
        XTN retVal = (XTN)this.getTypedField(10, 0);
        return retVal;
    }

    public XTN getCm010_ContactSTelephoneNumber() {
        XTN retVal = (XTN)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD[] getContactSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getCm011_ContactSAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public int getContactSAddressReps() {
        return this.getReps(11);
    }

    public XAD getContactSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getCm011_ContactSAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getCm011_ContactSAddressReps() {
        return this.getReps(11);
    }

    public XAD insertContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertCm011_ContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removeCm011_ContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new DT(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new XTN(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
        }
        return null;
    }
}

